/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.spider.monitor.facade.model;

import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 通用分页传输对象
 *
 * @ClassName SpiderReportDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/12/21 15:15
 * @Version 1.0
 **/
public class CommonQueryDto {

    @ApiModelProperty("页码，默认1")
    private Integer pageNum  = 1;

    @ApiModelProperty("每页数量，默认10")
    private Integer pageSize = 10;

    @ApiModelProperty("排序参数，默认id")
    private String  orderParam;

    @ApiModelProperty("排序方式：asc/desc，默认倒序desc")
    private String  orderType;

    @ApiModelProperty("查询开始时间yyyy-MM-dd HH:mm:ss格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date    startTime;

    @ApiModelProperty("查询结束时间yyyy-MM-dd HH:mm:ss格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date    endTime;

    /**
     * @return the pageNum
     */
    public Integer getPageNum() {
        return pageNum;
    }

    /**
     * @param pageNum the pageNum to set
     */
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum == null ? 1 : pageNum;
    }

    /**
     * @return the pageSize
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * @param pageSize the pageSize to set
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize == null ? 10 : pageSize;
    }

    /**
     * @return the orderParam
     */
    public String getOrderParam() {
        return orderParam;
    }

    /**
     * @param orderParam the orderParam to set
     */
    public void setOrderParam(String orderParam) {
        this.orderParam = orderParam;
    }

    /**
     * @return the orderType
     */
    public String getOrderType() {
        return orderType;
    }

    /**
     * @param orderType the orderType to set
     */
    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    /**
     * @return the startTime
     */
    public Date getStartTime() {
        return startTime;
    }

    /**
     * @param startTime the startTime to set
     */
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    /**
     * @return the endTime
     */
    public Date getEndTime() {
        return endTime;
    }

    /**
     * @param endTime the endTime to set
     */
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
}
