package com.bxm.spider.monitor.facade.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 监控报表传输对象
 *
 * @ClassName SpiderReportDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/12/21 15:15
 * @Version 1.0
 **/
@Data
public class SpiderMonitorReportDto extends CommonQueryDto {

    @ApiModelProperty("流水号")
    private String serialNum;

    @ApiModelProperty("网站类型：1全国内容，2地方内容，3地方测试新闻，4优惠券，21地方招聘，22地方新闻，221地方公众号，222地方网站，223地方app")
    private String siteType;

    @ApiModelProperty("url类型：列表 URL_LIST，详情：URL_DETAIL")
    private String urlType;

    @ApiModelProperty("流程类型：调度 PROD_PROGRESS，下载 DOWNLOAD_PROGRESS，解析 DEAL_PROGRESS，保存 SAVE_PROGRESS，可多选，逗号分隔")
    private String flowCodes;

    private List<String> flowCodeList;

}
