package com.bxm.spider.monitor.facade.service;

import com.bxm.spider.monitor.facade.model.SpiderExceptionMonitorVo;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportDto;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportVo;
import com.bxm.warcar.utils.response.ResponseModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * <p> 监控报表相关服务 </p>
 *
 * @Author: stephen
 * @Version 1.0
 * @Date: 2018/12/24
 */
@FeignClient(name ="monitor-service")
public interface MonitorReportFacadeService {

    /**
     * 分页查询站点列表
     * @param spiderMonitorReportDto
     * @return
     */
    @RequestMapping(value = "/monitorReport/getSitePageList", method = RequestMethod.POST)
    ResponseModel<PageInfo<SpiderMonitorReportVo>> getSitePageList(@RequestBody SpiderMonitorReportDto spiderMonitorReportDto);

    /**
     * 分页查询应用列表
     * @param spiderMonitorReportDto
     * @return
     */
    @RequestMapping(value = "/monitorReport/getAppPageList", method = RequestMethod.POST)
    ResponseModel<PageInfo<SpiderMonitorReportVo>> getAppPageList(@RequestBody SpiderMonitorReportDto spiderMonitorReportDto);

    /**
     * 分页查询错误列表
     * @param spiderMonitorReportDto
     * @return
     */
    @RequestMapping(value = "/monitorReport/getErrorPageList", method = RequestMethod.POST)
    ResponseModel<PageInfo<SpiderExceptionMonitorVo>> getErrorPageList(@RequestBody SpiderMonitorReportDto spiderMonitorReportDto);

}
