package com.bxm.spider.prod.param;

import com.bxm.spider.constant.processor.PretreatmentEnum;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.constant.proxy.ProxyFlagEnum;
import lombok.Data;
import org.apache.http.Header;
import org.springframework.http.HttpMethod;

import java.util.List;

/**
 * 下载数据传输对象
 *
 * @ClassName DownLoadDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/22 16:00
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/22 16:00
 **/
@Data
public class DownloadParam {
    private String method = HttpMethod.GET.name();

    private String referer;

    private String channel;

    private String cookie;

    private String userAgent;

    private String paramJsonString;
    /**
     * 是否使用代理
     */
    private ProxyFlagEnum proxyFlag;

    /**
     * 下载对象预处理类型
     */
    private PretreatmentEnum pretreatmentEnum;

    /**
     * 下载对象预处理参数
     */
    private String pretreatmentParam;

    /**
     * 编码
     */
    private String charset;

    /**
     * 公共参数
     */
    private ProcessorParameter processorParameter;

    /**
     * 是否下载html：如果为false,pageInfo 则写入流水号
     */
    private Boolean isDownload;

    /**
     * 登录账户列表
     */
    private List<LoginAccountParam> loginAccountParams;

    /**
     * 用于预处理增加header
     */
    private List<Header> extraHeader;
}
