/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.cache;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisClient {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClient.class);
    @Autowired
    @Qualifier(value="jedisPool")
    private JedisPool jedisPool;

    public String hGet(String key, String field) {
        return this.hGet(key, field, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hGet(String key, String field, Integer dbIndex) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)field)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("the key or field is null");
            }
            return null;
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            String string = jedis.hget(key, field);
            return string;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("hGet the key error,the key is {},the field is {}", new Object[]{key, field, e});
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return null;
    }

    public void hdel(String key, String field) {
        this.hdel(key, field, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hdel(String key, String field, Integer dbIndex) {
        if ((StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)field)) && LOG.isWarnEnabled()) {
            LOG.warn("the key or field is null");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            jedis.hdel(key, new String[]{field});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("hGet the key error,the key is {},the field is {}", new Object[]{key, field, e});
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public boolean exists(String key) {
        return this.exists(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key, Integer dbIndex) {
        if (StringUtils.isBlank((CharSequence)key) && LOG.isWarnEnabled()) {
            LOG.warn("the key is null");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("exists the key error,the key is {}", (Object)key, (Object)e);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return false;
    }

    public String hgetAnddel(String key, String field) {
        return this.hgetAnddel(key, field, null);
    }

    public String hgetAnddel(String key, String field, Integer dbIndex) {
        String result = this.hGet(key, field, dbIndex);
        this.hdel(key, field, dbIndex);
        return result;
    }

    public Long hincrByOne(String key, String field) {
        return this.hincrByOne(key, field, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hincrByOne(String key, String field, Integer dbIndex) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)field)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("the key or field is null");
            }
            return null;
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            Long l = jedis.hincrBy(key, field, 1L);
            return l;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("hincrByOne the key error,the key is {},the field is {}", new Object[]{key, field, e});
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return null;
    }

    public void hSet(String key, String field, String value) {
        this.hSet(key, field, value, null, null);
    }

    public void hSet(String key, String field, String value, Integer dbIndex) {
        this.hSet(key, field, value, dbIndex, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hSet(String key, String field, String value, Integer dbIndex, Integer expire) {
        if ((StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)field)) && LOG.isWarnEnabled()) {
            LOG.warn("the key or field is null");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            jedis.hset(key, field, value);
            if (null != expire && expire >= 0) {
                jedis.expire(key, expire.intValue());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("hSet the key error,the key is {},the field is {}, the value is {}", new Object[]{key, field, value, e});
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public void set(String key, String value) {
        this.set(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.set(key, value);
        }
    }

    public String get(String key) {
        return this.get(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            String string = jedis.get(key);
            return string;
        }
        return null;
    }

    public void sadd(String key, String value) {
        this.sadd(key, value, null);
    }

    public void sadd(String key, String value, Integer dbIndex) {
        this.sadd(key, value, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sadd(String key, String value, Integer dbIndex, Integer expire) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.sadd(key, new String[]{value});
            if (null != expire && expire > 0) {
                jedis.expire(key, expire.intValue());
            }
        }
    }

    public long lrem(String key, String value) {
        return this.lrem(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lrem(String key, String value, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            long l = jedis.lrem(key, -1L, value);
            return l;
        }
        return 0L;
    }

    public void rpush(String key, String value) {
        this.rpush(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rpush(String key, String value, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.rpush(key, new String[]{value});
        }
    }

    public void lpush(String key, String value) {
        this.lpush(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lpush(String key, String value, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.lpush(key, new String[]{value});
        }
    }

    public String lpop(String key) {
        return this.lpop(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lpop(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            String string = jedis.lpop(key);
            return string;
        }
        return null;
    }

    public long llen(String key) {
        return this.llen(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long llen(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            long l = jedis.llen(key);
            return l;
        }
        return 0L;
    }

    public String spop(String key) {
        return this.spop(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String spop(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            String string = jedis.spop(key);
            return string;
        }
        return null;
    }

    public void del(String key) {
        this.del(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.del(key);
        }
    }

    public boolean sismember(String key, String member) {
        return this.sismember(key, member, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sismember(String key, String member, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            boolean bl = jedis.sismember(key, member);
            return bl;
        }
        return false;
    }

    public Long srem(String key, String ... values) {
        return this.srem((Integer)null, key, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(Integer dbIndex, String key, String ... values) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return 0L;
        }
        if (!this.exists(key, dbIndex)) {
            LOG.warn("the key:{} is not exist!", (Object)key);
            return 0L;
        }
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            Long l = jedis.srem(key, values);
            return l;
        }
        return 0L;
    }

    public Set<String> sunion(String ... keys) {
        return this.sunion((Integer)null, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> sunion(Integer dbIndex, String ... keys) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            Set set = jedis.sunion(keys);
            return set;
        }
        return new HashSet<String>();
    }
}

