/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.service.controller;

import com.bxm.spider.prod.facade.model.dto.TaskDto;
import com.bxm.spider.prod.facade.model.dto.TaskUrlDto;
import com.bxm.spider.prod.facade.service.TaskFeignService;
import com.bxm.spider.prod.service.service.JobService;
import com.bxm.spider.prod.service.service.UrlDealService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task"})
public class SpiderController
implements TaskFeignService {
    @Autowired
    private JobService jobService;
    @Autowired
    private UrlDealService urlDealService;

    @Override
    @RequestMapping(value={"/start"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> start(@RequestBody TaskDto taskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.addCronJob(taskDto.getSerialNum()));
    }

    @Override
    @RequestMapping(value={"/pause"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> pause(@RequestBody TaskDto taskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.pauseJob(taskDto.getSerialNum()));
    }

    @Override
    @RequestMapping(value={"/resume"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> resume(@RequestBody TaskDto taskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.resumeJob(taskDto.getSerialNum()));
    }

    @Override
    @RequestMapping(value={"/stop"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> stop(@RequestBody TaskDto taskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.deleteJob(taskDto.getSerialNum()));
    }

    @Override
    @RequestMapping(value={"/restartAll"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> restartAll() {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.restartAllJob());
    }

    @Override
    @RequestMapping(value={"/pushDetailsList"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> pushDetailsList(@RequestBody TaskUrlDto taskUrlDto) {
        return ResponseModelFactory.SUCCESS((Object)this.urlDealService.pushDetailsList(taskUrlDto));
    }

    @Override
    @RequestMapping(value={"/pushQueueList"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> pushQueueList(@RequestBody TaskUrlDto taskUrlDto) {
        return ResponseModelFactory.SUCCESS((Object)this.urlDealService.pushQueueList(taskUrlDto));
    }

    @Override
    @RequestMapping(value={"/pushImageList"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> pushImageList(@RequestBody TaskUrlDto taskUrlDto) {
        return ResponseModelFactory.SUCCESS((Object)this.urlDealService.pushImageList(taskUrlDto));
    }
}

