/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.service.job;

import com.alibaba.fastjson.JSONObject;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.TaskKeyConstant;
import com.bxm.spider.constant.monitor.ErrorEnum;
import com.bxm.spider.constant.monitor.MonitorConstant;
import com.bxm.spider.constant.monitor.MonitorDto;
import com.bxm.spider.constant.monitor.MonitorHelper;
import com.bxm.spider.constant.processor.PretreatmentEnum;
import com.bxm.spider.constant.proxy.ProxyFlagEnum;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.download.facade.model.LoginAccountDto;
import com.bxm.spider.prod.integration.download.DownLoadIntegrationService;
import com.bxm.spider.prod.integration.download.model.DownLoadDto;
import com.bxm.spider.prod.model.dao.UrlConfig;
import com.bxm.spider.prod.service.constant.Constant;
import com.bxm.spider.prod.service.job.JobThreadPool;
import com.bxm.spider.prod.service.job.ProdJob;
import com.bxm.spider.prod.service.util.ProdServiceUtils;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SpiderQueueJob
extends ProdJob {
    private Logger logger = LoggerFactory.getLogger(SpiderQueueJob.class);
    private final Integer DEFAULT_EXECUTE_RATE = 1;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private DownLoadIntegrationService downLoadIntegrationService;
    @Autowired
    private JobThreadPool jobThreadPool;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String serialNum = "";
        try {
            JobDataMap data = context.getJobDetail().getJobDataMap();
            serialNum = data.getString(Constant.SERIAL_NUM);
            this.logger.info(MonitorConstant.MONITOR, MonitorHelper.ofSuccessLog((String)"PROD_START", (String)serialNum, (UrlTypeEnum)UrlTypeEnum.URL_LIST));
            String queueKey = TaskKeyConstant.getQueueList((String)serialNum);
            Integer executeRate = this.DEFAULT_EXECUTE_RATE;
            try {
                executeRate = data.getInt(Constant.EXECUTE_RATE);
            }
            catch (Exception e) {
                this.logger.error("SpiderQueueJob\u83b7\u53d6\u6267\u884c\u9891\u7387\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c {}, \u6d41\u6c34\u53f7\uff1a{}", new Object[]{this.DEFAULT_EXECUTE_RATE, executeRate, e});
            }
            for (int i = 0; i < executeRate; ++i) {
                UrlConfig urlConfig;
                String queueUrl = this.redisClient.lpop(queueKey);
                if (StringUtils.isEmpty((CharSequence)queueUrl)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("queue job:{}, pop url: null", (Object)context.getJobDetail().getKey());
                    continue;
                }
                String[] urls = queueUrl.split(Constant.URL_JOINT_CHAR);
                if (urls.length == 1) {
                    urlConfig = (UrlConfig)data.get((Object)urls[0]);
                } else if (urls.length == 2) {
                    urlConfig = (UrlConfig)data.get((Object)urls[0]);
                    queueUrl = urls[1];
                } else {
                    this.logger.warn("\u51fa\u73b0\u975e\u6cd5\u8bf7\u6c42url: {}, data:{}", (Object)queueUrl, (Object)data);
                    continue;
                }
                if (urlConfig == null) {
                    this.logger.warn("urlconfig \u4e0d\u5b58\u5728\uff01\u51fa\u73b0\u975e\u6cd5\u8bf7\u6c42url: {}, data: {}", (Object)queueUrl, (Object)data);
                    continue;
                }
                String requestUrl = queueUrl;
                Integer proxyFlag = urlConfig.getProxyFlag();
                if (ProxyFlagEnum.PROXY_OPEN.getCode().equals(proxyFlag)) {
                    this.jobThreadPool.executeScheduled(() -> this.executeDown(urlConfig, context, requestUrl, queueKey));
                    continue;
                }
                this.jobThreadPool.execute(() -> this.executeDown(urlConfig, context, requestUrl, queueKey));
            }
        }
        catch (Exception e) {
            this.logger.error(MonitorConstant.MONITOR, "\u3010\u6267\u884c\u961f\u5217\u4e0b\u8f7d\u51fa\u9519\u3011{} exception:", (Object)MonitorHelper.ofFailLog((String)"PROD_PROGRESS", (String)serialNum, (UrlTypeEnum)UrlTypeEnum.URL_LIST, (ErrorEnum)ErrorEnum.PROD_ERROR, (String)e.getMessage()), (Object)e);
        }
    }

    private void executeDown(UrlConfig urlConfig, JobExecutionContext context, String queueUrl, String queueKey) {
        Boolean success;
        int currentDepth;
        String serialNum = urlConfig.getSerialNum();
        if (StringUtils.isEmpty((CharSequence)this.redisClient.hGet(TaskKeyConstant.getTaskExecutingHash(), serialNum)) && this.logger.isDebugEnabled()) {
            this.logger.debug("\u4efb\u52a1\u5df2\u505c\u6b62\uff0c\u4e0d\u6267\u884c\u5217\u8868\u8c03\u5ea6\u64cd\u4f5c\uff01serialNum: {}", (Object)serialNum);
            return;
        }
        String jsonStr = this.redisClient.hgetAnddel(TaskKeyConstant.getUrlObjectHash((String)serialNum), queueUrl);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String cookie = urlConfig.getCookie();
        String userAgent = urlConfig.getUserAgent();
        String referer = urlConfig.getReferer();
        Integer queueDepth = urlConfig.getQueueDepth();
        String channel = urlConfig.getChannel();
        String originUrl = urlConfig.getUrl();
        String charset = urlConfig.getCharset();
        String pretreatmentParam = urlConfig.getPretreatmentParam();
        PretreatmentEnum pretreatmentType = StringUtils.isBlank((CharSequence)urlConfig.getPretreatmentType()) ? null : PretreatmentEnum.valueOf((String)urlConfig.getPretreatmentType());
        String processorType = null == jsonObject || null == jsonObject.get((Object)"processor") || "".equals(String.valueOf(jsonObject.get((Object)"processor"))) ? urlConfig.getProcessorType() : jsonObject.get((Object)"processor") + "";
        String persistenceType = null == jsonObject || null == jsonObject.get((Object)"persistence") || "".equals(String.valueOf(jsonObject.get((Object)"persistence"))) ? urlConfig.getPersistenceType() : jsonObject.get((Object)"persistence") + "";
        ProxyFlagEnum proxyFlag = ProxyFlagEnum.PROXY_OPEN.getCode().intValue() == urlConfig.getProxyFlag().intValue() ? ProxyFlagEnum.PROXY_OPEN : ProxyFlagEnum.PROXY_CLOSE;
        List<LoginAccountDto> loginAccountList = this.getLoginAccountDtoList(context);
        String originDepth = this.redisClient.hGet(TaskKeyConstant.getDepthCatchHash((String)serialNum), originUrl);
        int n = currentDepth = NumberUtils.isCreatable((String)originDepth) ? Integer.valueOf(originDepth) : -1;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("execute job: {}, origin url depth: {}", (Object)context.getJobDetail().getKey(), (Object)currentDepth);
        }
        if (currentDepth > queueDepth) {
            this.logger.info("\u5df2\u8fbe\u5230\u722c\u53d6\u6df1\u5ea6\u4e0a\u9650: {}\uff0c\u505c\u6b62\u6267\u884c\u5217\u8868url\u722c\u53d6, \u6d41\u6c34\u53f7\uff1a{}", (Object)queueDepth, (Object)serialNum);
            return;
        }
        DownLoadDto downLoadDto = ProdServiceUtils.ofDownloadDto(queueUrl, originUrl, cookie, userAgent, referer, channel, serialNum, UrlTypeEnum.URL_LIST, processorType, charset, pretreatmentParam, pretreatmentType, proxyFlag, persistenceType, null == jsonObject ? "" : jsonObject.getString("json_object"), loginAccountList);
        MonitorDto monitorDto = this.downLoadIntegrationService.httpDownLoad(downLoadDto);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("execute job: {}, download params:{}", (Object)context.getJobDetail().getKey(), (Object)downLoadDto);
        }
        if ((success = monitorDto.getSuccess()).booleanValue()) {
            this.redisClient.sadd(TaskKeyConstant.getQueueCatchSet((String)serialNum), queueUrl);
            this.logger.info("execute queue url success ,serialNum: {}, redis key: {}, url:{} ", new Object[]{serialNum, queueKey, queueUrl});
        } else {
            Integer code = monitorDto.getCode();
            if (ResponseModelFactory.ResponseCode.REQUEST_ERROR.getCode().intValue() == code.intValue()) {
                this.logger.warn("execute queue url: {} fail message:{} ,serialNum: {}, push to the end of the list, redis key: {}", new Object[]{queueUrl, ResponseModelFactory.ResponseCode.REQUEST_ERROR.getMessage(), serialNum, queueKey});
                this.redisClient.rpush(queueKey, queueUrl);
            } else {
                this.logger.error("execute queue url: {} error ,serialNum: {}, push to the end of the list, redis key: {}", new Object[]{queueUrl, serialNum, queueKey});
                this.redisClient.lpush(queueKey, queueUrl);
            }
        }
        this.logger.info(MonitorConstant.MONITOR, MonitorHelper.ofSuccessLog((String)"PROD_END", (String)serialNum, (UrlTypeEnum)UrlTypeEnum.URL_LIST));
    }
}

