/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.TaskKeyConstant;
import com.bxm.spider.constant.task.TaskStatusEnum;
import com.bxm.spider.prod.model.dao.UrlTask;
import com.bxm.spider.prod.service.constant.ConfigStatusEnum;
import com.bxm.spider.prod.service.constant.Constant;
import com.bxm.spider.prod.service.job.SpiderDetailsJob;
import com.bxm.spider.prod.service.job.SpiderJob;
import com.bxm.spider.prod.service.job.SpiderQueueJob;
import com.bxm.spider.prod.service.service.JobService;
import com.bxm.spider.prod.service.service.LoginAccountService;
import com.bxm.spider.prod.service.service.UrlConfigService;
import com.bxm.spider.prod.service.service.UrlTaskService;
import com.bxm.spider.prod.service.util.ProdServiceUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobServiceImpl
implements JobService {
    private Logger logger = LoggerFactory.getLogger(JobServiceImpl.class);
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private UrlTaskService urlTaskService;
    @Autowired
    private UrlConfigService urlConfigService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private LoginAccountService loginAccountService;

    @Override
    public boolean addCronJob(String serialNum) {
        return this.addCronJob(serialNum, SpiderJob.class, SpiderQueueJob.class, SpiderDetailsJob.class);
    }

    @Override
    public boolean addCronJob(String serialNum, Class<? extends Job> jobClass, Class<? extends Job> jobQueueClass, Class<? extends Job> jobDetailsClass) {
        try {
            String jobGroup = this.getGroupBySerialNum(serialNum);
            String jobName = ProdServiceUtils.getJobName(serialNum);
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (jobDetail != null) {
                this.logger.warn("job: {} \u5df2\u5b58\u5728\uff01", (Object)jobName);
                return false;
            }
            UrlTask urlTask = (UrlTask)this.urlTaskService.selectOne(new EntityWrapper().eq("serial_num", (Object)serialNum));
            jobDetail = this.initJobDetail(jobClass, jobName, jobGroup, serialNum);
            CronTrigger cronTrigger = this.initCronTrigger(jobName, jobGroup, urlTask.getSchule());
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            this.logger.info("add cron job: {} success\uff01", (Object)jobName);
            String queueJobName = ProdServiceUtils.getQueueJobName(serialNum);
            jobDetail = this.initJobDetail(jobQueueClass, queueJobName, jobGroup, serialNum);
            jobDetail.getJobDataMap().put(Constant.EXECUTE_RATE, (Object)urlTask.getQueueRate());
            cronTrigger = this.initCronTrigger(queueJobName, jobGroup, urlTask.getQueueSchule());
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            this.logger.info("add cron job: {} success\uff01", (Object)queueJobName);
            String detailsJobName = ProdServiceUtils.getDetailsJobName(serialNum);
            jobDetail = this.initJobDetail(jobDetailsClass, detailsJobName, jobGroup, serialNum);
            jobDetail.getJobDataMap().put(Constant.EXECUTE_RATE, (Object)urlTask.getDetailsRate());
            cronTrigger = this.initCronTrigger(detailsJobName, jobGroup, urlTask.getDetailsSchule());
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            this.logger.info("add cron job: {} success\uff01", (Object)detailsJobName);
            return true;
        }
        catch (Exception e) {
            this.deleteJob(serialNum);
            this.logger.error("add cron job: {} error", (Object)ProdServiceUtils.getJobName(serialNum), (Object)e);
            return false;
        }
    }

    @Override
    public boolean pauseJob(String serialNum) {
        try {
            String jobGroup = this.getGroupBySerialNum(serialNum);
            String jobName = ProdServiceUtils.getJobName(serialNum);
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            this.scheduler.pauseTrigger(triggerKey);
            String queueJobName = ProdServiceUtils.getQueueJobName(serialNum);
            triggerKey = TriggerKey.triggerKey((String)queueJobName, (String)jobGroup);
            this.scheduler.pauseTrigger(triggerKey);
            String detailsJobName = ProdServiceUtils.getDetailsJobName(serialNum);
            triggerKey = TriggerKey.triggerKey((String)detailsJobName, (String)jobGroup);
            this.scheduler.pauseTrigger(triggerKey);
            this.logger.info("pause job: {}, {}, {} success\uff01", new Object[]{jobName, queueJobName, detailsJobName});
            return true;
        }
        catch (SchedulerException e) {
            this.logger.error("pause job {} error", (Object)ProdServiceUtils.getJobName(serialNum), (Object)e);
            return false;
        }
    }

    @Override
    public boolean resumeJob(String serialNum) {
        try {
            String jobGroup = this.getGroupBySerialNum(serialNum);
            String jobName = ProdServiceUtils.getJobName(serialNum);
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            this.scheduler.resumeTrigger(triggerKey);
            String queueJobName = ProdServiceUtils.getQueueJobName(serialNum);
            triggerKey = TriggerKey.triggerKey((String)queueJobName, (String)jobGroup);
            this.scheduler.resumeTrigger(triggerKey);
            String detailsJobName = ProdServiceUtils.getDetailsJobName(serialNum);
            triggerKey = TriggerKey.triggerKey((String)detailsJobName, (String)jobGroup);
            this.scheduler.resumeTrigger(triggerKey);
            this.logger.info("resume job: {}, {}, {} success", new Object[]{jobName, queueJobName, detailsJobName});
            return true;
        }
        catch (SchedulerException e) {
            this.logger.error("resume job {} error", (Object)ProdServiceUtils.getJobName(serialNum), (Object)e);
            return false;
        }
    }

    @Override
    public boolean deleteJob(String serialNum) {
        try {
            String jobGroup = this.getGroupBySerialNum(serialNum);
            String jobName = ProdServiceUtils.getJobName(serialNum);
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            this.scheduler.deleteJob(jobKey);
            String queueJobName = ProdServiceUtils.getQueueJobName(serialNum);
            jobKey = JobKey.jobKey((String)queueJobName, (String)jobGroup);
            this.scheduler.deleteJob(jobKey);
            String detailsJobName = ProdServiceUtils.getDetailsJobName(serialNum);
            jobKey = JobKey.jobKey((String)detailsJobName, (String)jobGroup);
            this.scheduler.deleteJob(jobKey);
            this.logger.info("delete job: {}, {}, {} success", new Object[]{jobName, queueJobName, detailsJobName});
            this.redisClient.del(TaskKeyConstant.getCatchSet((String)serialNum));
            this.redisClient.del(TaskKeyConstant.getQueueList((String)serialNum));
            this.redisClient.del(TaskKeyConstant.getDetailList((String)serialNum));
            this.redisClient.del(TaskKeyConstant.getDepthCatchHash((String)serialNum));
            this.redisClient.del(TaskKeyConstant.getQueueCatchSet((String)serialNum));
            this.redisClient.del(TaskKeyConstant.getUrlObjectHash((String)serialNum));
            this.redisClient.hdel(TaskKeyConstant.getTaskExecutingHash(), serialNum);
            return true;
        }
        catch (SchedulerException e) {
            this.logger.error("delete job {} error", (Object)ProdServiceUtils.getJobName(serialNum), (Object)e);
            return false;
        }
    }

    @Override
    public boolean restartAllJob() {
        int successCount = 0;
        int failCount = 0;
        List urlTaskList = this.urlTaskService.selectList(new EntityWrapper().eq("execute_status", (Object)TaskStatusEnum.RUNNING.getCode()));
        for (UrlTask urlTask : urlTaskList) {
            String serialNum = urlTask.getSerialNum();
            try {
                boolean success = this.deleteJob(serialNum);
                if (success && (success = this.addCronJob(serialNum))) {
                    this.logger.info("restart task success, serialNum: {}", (Object)serialNum);
                    ++successCount;
                }
                if (success) continue;
                this.logger.warn("restart task fail, serialNum: {}", (Object)serialNum);
                ++failCount;
            }
            catch (Exception e) {
                this.logger.error("restart task error, serialNum: {}", (Object)serialNum);
                ++failCount;
            }
        }
        this.logger.info("restart all task finish, success: {}, fail: {}", (Object)successCount, (Object)failCount);
        return true;
    }

    private JobDetail initJobDetail(Class<? extends Job> jobClass, String jobName, String jobGroup, String serialNum) {
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroup).build();
        List urlConfigList = this.urlConfigService.selectList(new EntityWrapper().eq("serial_num", (Object)serialNum).eq("status", (Object)ConfigStatusEnum.USABLE.getCode()));
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put(Constant.SERIAL_NUM, serialNum);
        if (CollectionUtils.isNotEmpty((Collection)urlConfigList)) {
            urlConfigList.forEach(urlConfig -> jobDataMap.put(urlConfig.getUrl(), urlConfig));
        }
        List loginAccounts = this.loginAccountService.selectList(new EntityWrapper().eq("serial_num", (Object)serialNum));
        jobDataMap.put(Constant.LOGIN_ACCOUNT_LIST, (Object)loginAccounts);
        return jobDetail;
    }

    private CronTrigger initCronTrigger(String jobName, String jobGroup, String schule) {
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)schule);
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        return trigger;
    }

    private String getGroupBySerialNum(String serialNum) {
        UrlTask urlTask = (UrlTask)this.urlTaskService.selectOne(new EntityWrapper().setSqlSelect("name").eq("serial_num", (Object)serialNum));
        if (urlTask != null && StringUtils.isNotEmpty((CharSequence)urlTask.getName())) {
            return ProdServiceUtils.getJobGroupName(urlTask.getName());
        }
        return ProdServiceUtils.getJobGroupName(Constant.DEFAULT_URL_GROUP);
    }
}

