/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.service.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.TaskKeyConstant;
import com.bxm.spider.constant.monitor.MonitorDto;
import com.bxm.spider.constant.processor.PretreatmentEnum;
import com.bxm.spider.constant.processor.ProcessorEnum;
import com.bxm.spider.constant.proxy.ProxyFlagEnum;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.prod.facade.model.dto.TaskUrlDto;
import com.bxm.spider.prod.integration.download.DownLoadIntegrationService;
import com.bxm.spider.prod.integration.download.model.DownLoadDto;
import com.bxm.spider.prod.model.dao.UrlConfig;
import com.bxm.spider.prod.service.constant.Constant;
import com.bxm.spider.prod.service.service.UrlConfigService;
import com.bxm.spider.prod.service.service.UrlDealService;
import com.bxm.spider.prod.service.util.ProdServiceUtils;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UrlDealServiceImpl
implements UrlDealService {
    private Logger logger = LoggerFactory.getLogger(UrlDealServiceImpl.class);
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private UrlConfigService urlConfigService;
    @Autowired
    private DownLoadIntegrationService downLoadIntegrationService;
    private final ExecutorService executorService = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("urlDealServiceImpl"));

    @Override
    public boolean pushDetailsList(TaskUrlDto taskUrlDto) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)taskUrlDto.getJsonObject())) {
            jsonObject.put("json_object", (Object)taskUrlDto.getJsonObject());
        }
        if (null != taskUrlDto.getPersistenceEnum() && StringUtils.isNotBlank((CharSequence)taskUrlDto.getPersistenceEnum().getName())) {
            jsonObject.put("persistence", (Object)taskUrlDto.getPersistenceEnum().getName());
        }
        if (null != taskUrlDto.getProcessorEnum() && StringUtils.isNotBlank((CharSequence)taskUrlDto.getProcessorEnum().getName())) {
            jsonObject.put("processor", (Object)taskUrlDto.getProcessorEnum().getName());
        }
        String serialNum = taskUrlDto.getSerialNum();
        String originUrl = taskUrlDto.getOriginUrl();
        String detailsKey = TaskKeyConstant.getDetailList((String)serialNum);
        List detailsUrlList = JSONArray.parseArray((String)taskUrlDto.getUrlList(), String.class);
        for (String url : detailsUrlList) {
            if (taskUrlDto.getForcedDownload().booleanValue()) {
                this.redisClient.rpush(detailsKey, ProdServiceUtils.getSaveUrl(originUrl, url));
                this.redisClient.hSet(TaskKeyConstant.getUrlObjectHash((String)serialNum), url, jsonObject.toJSONString());
                continue;
            }
            boolean isMember = this.redisClient.sismember(TaskKeyConstant.getCatchSet((String)serialNum), url);
            if (isMember) continue;
            this.redisClient.rpush(detailsKey, ProdServiceUtils.getSaveUrl(originUrl, url));
            this.redisClient.hSet(TaskKeyConstant.getUrlObjectHash((String)serialNum), url, jsonObject.toJSONString());
        }
        return true;
    }

    @Override
    public boolean pushQueueList(TaskUrlDto taskUrlDto) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)taskUrlDto.getJsonObject())) {
            jsonObject.put("json_object", (Object)taskUrlDto.getJsonObject());
        }
        if (null != taskUrlDto.getPersistenceEnum() && StringUtils.isNotBlank((CharSequence)taskUrlDto.getPersistenceEnum().getName())) {
            jsonObject.put("persistence", (Object)taskUrlDto.getPersistenceEnum().getName());
        }
        if (null != taskUrlDto.getProcessorEnum() && StringUtils.isNotBlank((CharSequence)taskUrlDto.getProcessorEnum().getName())) {
            jsonObject.put("processor", (Object)taskUrlDto.getProcessorEnum().getName());
        }
        String serialNum = taskUrlDto.getSerialNum();
        String originUrl = taskUrlDto.getOriginUrl();
        UrlConfig urlConfig = (UrlConfig)this.urlConfigService.selectOne(new EntityWrapper().eq("serial_num", (Object)serialNum).eq("url", (Object)originUrl));
        if (urlConfig == null) {
            this.logger.warn("\u6570\u636e\u5f02\u5e38\uff01\u5217\u8868url urlConfig \u4e0d\u5b58\u5728,taskUrlDto:{}", (Object)taskUrlDto);
            return false;
        }
        Integer depth = urlConfig.getQueueDepth() == null ? Constant.DEFAULT_DEPTH : urlConfig.getQueueDepth();
        String queueKey = TaskKeyConstant.getQueueList((String)serialNum);
        List queueUrlList = JSONArray.parseArray((String)taskUrlDto.getUrlList(), String.class);
        for (String url : queueUrlList) {
            String times = this.redisClient.hGet(TaskKeyConstant.getDepthCatchHash((String)serialNum), originUrl);
            if (times != null && Integer.valueOf(times) >= depth) continue;
            if (taskUrlDto.getForcedDownload().booleanValue()) {
                this.redisClient.hincrByOne(TaskKeyConstant.getDepthCatchHash((String)serialNum), originUrl);
                this.redisClient.rpush(queueKey, ProdServiceUtils.getSaveUrl(originUrl, url));
                this.redisClient.hSet(TaskKeyConstant.getUrlObjectHash((String)serialNum), url, jsonObject.toJSONString());
                continue;
            }
            boolean isMember = this.redisClient.sismember(TaskKeyConstant.getQueueCatchSet((String)serialNum), url);
            if (isMember) continue;
            this.redisClient.hincrByOne(TaskKeyConstant.getDepthCatchHash((String)serialNum), originUrl);
            this.redisClient.rpush(queueKey, ProdServiceUtils.getSaveUrl(originUrl, url));
            this.redisClient.hSet(TaskKeyConstant.getUrlObjectHash((String)serialNum), url, jsonObject.toJSONString());
        }
        return true;
    }

    @Override
    public boolean pushImageList(TaskUrlDto taskUrlDto) {
        if (null == taskUrlDto) {
            this.logger.error("image url is null!");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)taskUrlDto.getUrlList()) || StringUtils.isBlank((CharSequence)taskUrlDto.getSerialNum()) || StringUtils.isBlank((CharSequence)taskUrlDto.getOriginUrl())) {
            this.logger.error("image url is empty or serialNum is empty or origin url is empty!");
            return false;
        }
        String serialNum = taskUrlDto.getSerialNum();
        String originUrl = taskUrlDto.getOriginUrl();
        UrlConfig urlConfig = (UrlConfig)this.urlConfigService.selectOne(new EntityWrapper().eq("serial_num", (Object)serialNum).eq("url", (Object)originUrl));
        if (urlConfig == null) {
            this.logger.warn("\u6570\u636e\u5f02\u5e38\uff01\u56fe\u7247url urlConfig \u4e0d\u5b58\u5728,taskUrlDto:{}", (Object)taskUrlDto);
            return false;
        }
        String cookie = urlConfig.getCookie();
        String userAgent = urlConfig.getUserAgent();
        String referer = urlConfig.getReferer();
        String channel = urlConfig.getChannel();
        String charset = urlConfig.getCharset();
        String pretreatmentParam = urlConfig.getPretreatmentParam();
        PretreatmentEnum pretreatmentType = StringUtils.isBlank((CharSequence)urlConfig.getPretreatmentType()) ? null : PretreatmentEnum.valueOf((String)urlConfig.getPretreatmentType());
        String processorType = ProcessorEnum.IMAGE.getName();
        String persistenceType = null == taskUrlDto.getPersistenceEnum() ? urlConfig.getPersistenceType() : taskUrlDto.getPersistenceEnum().getName();
        String object = taskUrlDto.getJsonObject();
        String imageKey = TaskKeyConstant.getImageCatchSet((String)serialNum);
        List imageUrlList = JSONArray.parseArray((String)taskUrlDto.getUrlList(), String.class);
        for (String url : imageUrlList) {
            this.executorService.execute(() -> {
                if (StringUtils.isBlank((CharSequence)url)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("the url is null,origin url is {},serialNum is {} ", (Object)originUrl, (Object)serialNum);
                    }
                    return;
                }
                boolean isMember = this.redisClient.sismember(imageKey, url);
                if (isMember && !taskUrlDto.getForcedDownload().booleanValue()) {
                    return;
                }
                DownLoadDto downLoadDto = ProdServiceUtils.ofDownloadDto(url, originUrl, cookie, userAgent, referer, channel, serialNum, UrlTypeEnum.URL_DETAIL, processorType, charset, pretreatmentParam, pretreatmentType, ProxyFlagEnum.PROXY_CLOSE, persistenceType, object, Lists.newArrayList());
                MonitorDto monitorDto = this.downLoadIntegrationService.httpDownLoadImage(downLoadDto);
                Boolean success = monitorDto.getSuccess();
                if (success.booleanValue()) {
                    this.redisClient.sadd(imageKey, url);
                    this.logger.info("execute image url success! serialNum: {}, redis key: {}, url: {}", new Object[]{serialNum, imageKey, url});
                } else {
                    Integer code = monitorDto.getCode();
                    if (ResponseModelFactory.ResponseCode.REQUEST_ERROR.getCode().intValue() == code.intValue()) {
                        this.logger.error("execute image url: {} fail message:{} ,serialNum: {}, push to the end of the list, redis key: {}", new Object[]{url, ResponseModelFactory.ResponseCode.REQUEST_ERROR.getMessage(), serialNum, imageKey});
                    } else {
                        this.logger.error("execute details url: {} error ,serialNum: {}, push to the end of the list, redis key: {}", new Object[]{url, serialNum, imageKey});
                    }
                }
                this.logger.info("\u3010\u56fe\u7247\u8c03\u5ea6\u7ed3\u675f\u3011url:{},\u5b58\u50a8\u5668:{}", (Object)url, (Object)downLoadDto.getProcessorParameter().getPersistenceEnum().getName());
            });
        }
        return true;
    }
}

