/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.service.util;

import com.bxm.spider.constant.processor.PersistenceEnum;
import com.bxm.spider.constant.processor.PretreatmentEnum;
import com.bxm.spider.constant.processor.ProcessorEnum;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.constant.proxy.ProxyFlagEnum;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.download.facade.model.LoginAccountDto;
import com.bxm.spider.prod.integration.download.model.DownLoadDto;
import com.bxm.spider.prod.service.constant.Constant;
import com.bxm.spider.prod.service.job.SpiderQueueJob;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProdServiceUtils {
    private static Logger logger = LoggerFactory.getLogger(SpiderQueueJob.class);

    public static String getDetailsJobName(String serialNum) {
        return StringUtils.join((Object[])new String[]{Constant.JOB_DETAILS_HEAD, serialNum}, (String)"_");
    }

    public static String getQueueJobName(String serialNum) {
        return StringUtils.join((Object[])new String[]{Constant.JOB_QUEUE_HEAD, serialNum}, (String)"_");
    }

    public static String getJobName(String serialNum) {
        return StringUtils.join((Object[])new String[]{Constant.JOB_HEAD, serialNum}, (String)"_");
    }

    public static String getJobGroupName(String taskName) {
        return StringUtils.join((Object[])new String[]{Constant.JOB_GROUP_HEAD, taskName}, (String)"_");
    }

    public static DownLoadDto ofDownloadDto(String url, String originUrl, String cookie, String userAgent, String referer, String channel, String serialNum, UrlTypeEnum urlTypeEnum, String processorEnumName, String charset, String pretreatmentParam, PretreatmentEnum pretreatmentEnum, ProxyFlagEnum proxyFlag, String persistenceType, String object, List<LoginAccountDto> loginAccountDtoList) {
        try {
            DownLoadDto downLoadDto = new DownLoadDto();
            ProcessorParameter processorParameter = new ProcessorParameter();
            processorParameter.setSerialNum(serialNum);
            processorParameter.setUrl(StringUtils.replaceAll((String)url, (String)"\\s", (String)""));
            processorParameter.setOriginUrl(originUrl);
            processorParameter.setType(urlTypeEnum);
            processorParameter.setProcessorEnum(ProcessorEnum.valueOf((String)processorEnumName));
            processorParameter.setJsonObject(object);
            processorParameter.setPersistenceEnum(PersistenceEnum.valueOf((String)persistenceType));
            downLoadDto.setProcessorParameter(processorParameter);
            downLoadDto.setPretreatmentEnum(pretreatmentEnum);
            downLoadDto.setPretreatmentParam(pretreatmentParam);
            downLoadDto.setCharset(charset);
            downLoadDto.setUserAgent(userAgent);
            downLoadDto.setCookie(cookie);
            downLoadDto.setChannel(channel);
            downLoadDto.setReferer(referer);
            downLoadDto.setProxyFlag(proxyFlag);
            downLoadDto.setLoginAccountDtoList(loginAccountDtoList);
            return downLoadDto;
        }
        catch (Exception e) {
            logger.error("ofDownloadDto error : ", (Throwable)e);
            return null;
        }
    }

    public static String getSaveUrl(String originUrl, String url) {
        return StringUtils.join((Object[])new String[]{originUrl, url}, (String)Constant.URL_JOINT_CHAR);
    }

    public static void main(String[] args) {
        DownLoadDto downLoadDto = ProdServiceUtils.ofDownloadDto("url", "originUrl", "cookie", "userAgent", "referer", "channel", "serialNum", UrlTypeEnum.URL_DETAIL, "HTML", "UTF-8", "u@RANDOMSTR", PretreatmentEnum.URL, ProxyFlagEnum.PROXY_CLOSE, "NEWS", "object", null);
        System.out.println(downLoadDto);
    }
}

