/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.ProvisionException;
import com.netflix.governator.LifecycleAction;
import com.netflix.governator.LifecycleFeature;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationMapper;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.lifecycle.LifecycleMethods;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConfigurationLifecycleFeature
implements LifecycleFeature {
    private ConfigurationMapper mapper;
    private ConfigurationProvider configurationProvider;
    private ConfigurationDocumentation configurationDocumentation;

    @Inject
    public void initialize(ConfigurationMapper mapper, ConfigurationProvider configurationProvider, ConfigurationDocumentation configurationDocumentation) {
        this.mapper = mapper;
        this.configurationDocumentation = configurationDocumentation;
        this.configurationProvider = configurationProvider;
    }

    public List<LifecycleAction> getActionsForType(final Class<?> type) {
        final LifecycleMethods methods = new LifecycleMethods(type);
        if (!methods.fieldsFor(Configuration.class).isEmpty()) {
            return Arrays.asList(new LifecycleAction(){

                public void call(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    if (ConfigurationLifecycleFeature.this.mapper == null) {
                        throw new ProvisionException("Trying to map fields of type " + type.getName() + " before ConfigurationLifecycleFeature was fully initialized by the injector");
                    }
                    try {
                        ConfigurationLifecycleFeature.this.mapper.mapConfiguration(ConfigurationLifecycleFeature.this.configurationProvider, ConfigurationLifecycleFeature.this.configurationDocumentation, obj, methods);
                    }
                    catch (Exception e) {
                        throw new ProvisionException("Failed to map configuration for type " + type.getName(), (Throwable)e);
                    }
                }
            });
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "Configuration";
    }
}

