/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.netflix.governator.configuration.ColumnPrinter;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;

public class ConfigurationColumnWriter {
    private final ConfigurationDocumentation config;

    @Inject
    public ConfigurationColumnWriter(ConfigurationDocumentation config) {
        this.config = config;
    }

    public void output(Logger log) {
        Map<String, ConfigurationDocumentation.Entry> entries = this.config.getSortedEntries();
        if (entries.isEmpty()) {
            return;
        }
        ColumnPrinter printer = this.build(entries);
        log.debug("Configuration Details");
        for (String line : printer.generate()) {
            log.debug(line);
        }
    }

    public void output() {
        this.output(new PrintWriter(System.out));
    }

    public void output(PrintWriter out) {
        Map<String, ConfigurationDocumentation.Entry> entries = this.config.getSortedEntries();
        if (entries.isEmpty()) {
            return;
        }
        ColumnPrinter printer = this.build(entries);
        out.println("Configuration Details");
        printer.print(out);
    }

    private ColumnPrinter build(Map<String, ConfigurationDocumentation.Entry> entries) {
        ColumnPrinter printer = new ColumnPrinter();
        printer.addColumn("PROPERTY");
        printer.addColumn("FIELD");
        printer.addColumn("DEFAULT");
        printer.addColumn("VALUE");
        printer.addColumn("DESCRIPTION");
        TreeMap sortedEntries = Maps.newTreeMap();
        sortedEntries.putAll(entries);
        for (ConfigurationDocumentation.Entry entry : sortedEntries.values()) {
            printer.addValue(0, entry.configurationName);
            printer.addValue(1, entry.field.getDeclaringClass().getName() + "#" + entry.field.getName());
            printer.addValue(2, entry.defaultValue);
            printer.addValue(3, entry.has ? entry.value : "");
            printer.addValue(4, entry.documentation);
        }
        return printer;
    }
}

