/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import feign.Client;
import feign.Feign;
import feign.httpclient.ApacheHttpClient;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.netflix.feign.DefaultTargeter;
import org.springframework.cloud.netflix.feign.FeignClientSpecification;
import org.springframework.cloud.netflix.feign.FeignContext;
import org.springframework.cloud.netflix.feign.HystrixTargeter;
import org.springframework.cloud.netflix.feign.Targeter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Feign.class})
public class FeignAutoConfiguration {
    @Autowired(required=false)
    private List<FeignClientSpecification> configurations = new ArrayList<FeignClientSpecification>();

    @Bean
    public HasFeatures feignFeature() {
        return HasFeatures.namedFeature((String)"Feign", Feign.class);
    }

    @Bean
    public FeignContext feignContext() {
        FeignContext context = new FeignContext();
        context.setConfigurations(this.configurations);
        return context;
    }

    @Configuration
    @ConditionalOnClass(value={feign.okhttp.OkHttpClient.class})
    @ConditionalOnMissingClass(value={"com.netflix.loadbalancer.ILoadBalancer"})
    @ConditionalOnProperty(value={"feign.okhttp.enabled"}, matchIfMissing=true)
    protected static class OkHttpFeignConfiguration {
        @Autowired(required=false)
        private OkHttpClient okHttpClient;

        protected OkHttpFeignConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Client.class})
        public Client feignClient() {
            if (this.okHttpClient != null) {
                return new feign.okhttp.OkHttpClient(this.okHttpClient);
            }
            return new feign.okhttp.OkHttpClient();
        }
    }

    @Configuration
    @ConditionalOnClass(value={ApacheHttpClient.class})
    @ConditionalOnMissingClass(value={"com.netflix.loadbalancer.ILoadBalancer"})
    @ConditionalOnProperty(value={"feign.httpclient.enabled"}, matchIfMissing=true)
    protected static class HttpClientFeignConfiguration {
        @Autowired(required=false)
        private HttpClient httpClient;

        protected HttpClientFeignConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Client.class})
        public Client feignClient() {
            if (this.httpClient != null) {
                return new ApacheHttpClient(this.httpClient);
            }
            return new ApacheHttpClient();
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"feign.hystrix.HystrixFeign"})
    protected static class DefaultFeignTargeterConfiguration {
        protected DefaultFeignTargeterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Targeter feignTargeter() {
            return new DefaultTargeter();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"feign.hystrix.HystrixFeign"})
    protected static class HystrixFeignTargeterConfiguration {
        protected HystrixFeignTargeterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Targeter feignTargeter() {
            return new HystrixTargeter();
        }
    }
}

