/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.utils;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.bxm.spider.config.UploadProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={UploadProperties.class})
public class UploadImgUtil {
    @Autowired
    private UploadProperties uploadProperties;
    private final String path = "/spider/";
    private final String defaultPath = "20181203666666/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(File file, String fileUrl) throws ClientException {
        if (file == null) {
            return null;
        }
        if (fileUrl.startsWith("/")) {
            fileUrl = fileUrl.substring(1, fileUrl.length());
        }
        OSSClient ossClient = new OSSClient(this.uploadProperties.getEndPoint(), this.uploadProperties.getAccessKeyId(), this.uploadProperties.getAccessKeySecret());
        try {
            this.checkBucket(ossClient, this.uploadProperties.getBucketName());
            PutObjectResult result = ossClient.putObject(new PutObjectRequest(this.uploadProperties.getBucketName(), fileUrl, file));
            if (null != result) {
                String string = this.uploadProperties.getImgFileHost() + fileUrl;
                return string;
            }
        }
        catch (OSSException oe) {
            oe.printStackTrace();
        }
        finally {
            ossClient.shutdown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(InputStream inputStream, String fileUrl) throws FileNotFoundException, ClientException {
        if (inputStream == null) {
            return null;
        }
        if (fileUrl.startsWith("/")) {
            fileUrl = fileUrl.substring(1, fileUrl.length());
        }
        OSSClient ossClient = new OSSClient(this.uploadProperties.getEndPoint(), this.uploadProperties.getAccessKeyId(), this.uploadProperties.getAccessKeySecret());
        try {
            this.checkBucket(ossClient, this.uploadProperties.getBucketName());
            PutObjectResult result = ossClient.putObject(new PutObjectRequest(this.uploadProperties.getBucketName(), fileUrl, inputStream));
            if (null != result) {
                String string = this.uploadProperties.getImgFileHost() + fileUrl;
                return string;
            }
        }
        catch (OSSException oe) {
            oe.printStackTrace();
        }
        finally {
            ossClient.shutdown();
        }
        return null;
    }

    private void checkBucket(OSSClient ossClient, String bucketName) {
        if (!ossClient.doesBucketExist(bucketName)) {
            ossClient.createBucket(bucketName);
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
            createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
            ossClient.createBucket(createBucketRequest);
        }
    }

    public static void main(String[] args) {
        try {
            UploadImgUtil uploadImgUtil = new UploadImgUtil();
            uploadImgUtil.uploadProperties = new UploadProperties();
            File file = new File("d:\\11.png");
            FileInputStream inputStream = new FileInputStream(file);
            String upload = uploadImgUtil.upload(inputStream, "/test/1111.png");
            System.out.println(upload);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOSSUrl(String url, String serialNum) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.setConfig(RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build());
        try {
            String finalUrl;
            String imgName = UUID.randomUUID() + "-spider.png";
            String pathName = this.path;
            pathName = StringUtils.isNotBlank((CharSequence)serialNum) ? pathName + serialNum + "/" : pathName + "20181203666666/";
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            InputStream inputStream = response.getEntity().getContent();
            String string = finalUrl = this.upload(inputStream, pathName + imgName);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            httpGet.releaseConnection();
        }
        return null;
    }
}

