/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build();

    private HttpUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject httpPost(String url, JSONObject jsonParam) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        JSONObject jsonResult = null;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        try {
            if (null != jsonParam) {
                StringEntity entity = new StringEntity(jsonParam.toString(), "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)httpPost);
            jsonResult = HttpUtils.getJsonResult(result, url);
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            httpPost.releaseConnection();
        }
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject httpPost(String url, String strParam) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        JSONObject jsonResult = null;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        try {
            if (null != strParam) {
                StringEntity entity = new StringEntity(strParam, "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/x-www-form-urlencoded");
                httpPost.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)httpPost);
            jsonResult = HttpUtils.getJsonResult(result, url);
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            httpPost.releaseConnection();
        }
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject httpGet(String url) {
        JSONObject jsonResult = null;
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet request = new HttpGet(url);
        request.setConfig(requestConfig);
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String strResult = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                jsonResult = JSONObject.parseObject((String)strResult);
            } else {
                logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url);
            }
        }
        catch (IOException e) {
            logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            request.releaseConnection();
        }
        return jsonResult;
    }

    public static String getIpFromHeader(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotBlank((CharSequence)ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip.indexOf(44) == -1 ? ip : ip.substring(0, ip.indexOf(44));
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private static JSONObject getJsonResult(CloseableHttpResponse result, String url) {
        JSONObject jsonResult = null;
        if (result.getStatusLine().getStatusCode() == 200) {
            String str = "";
            try {
                str = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"utf-8");
                jsonResult = JSONObject.parseObject((String)str);
            }
            catch (Exception e) {
                logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
            }
        }
        return jsonResult;
    }

    public static void main(String[] args) {
        JSONObject get = HttpUtils.httpGet("https://blog.csdn.net/qq_35712358/phoenix/comment/list/71426070?page=1&size=3");
        JSONObject post = HttpUtils.httpPost("https://buy.bianxianmao.com/award/awardPopupInfo", "appkey=fbca14bb5bb74d5a9b5fa165ad78a15a&business=money-4&i=&f=&ua=0&activityid=12511&uid=8F5566E1C5B958C8E924C14EA242AC0A&appos=1&popupType=&scene=");
        System.out.println(get);
        System.out.println(post);
    }
}

