/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.file;

import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.utils.file.FingerprintTracker;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFingerprintTracker
implements FingerprintTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleFingerprintTracker.class);
    private final String url;

    public SimpleFingerprintTracker(String url) {
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFingerprint() {
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        try {
            urlConnection = (HttpURLConnection)new URL(this.url).openConnection();
            inputStream = urlConnection.getInputStream();
            byte[] buffer = new byte[inputStream.available()];
            IOUtils.readFully((InputStream)inputStream, (byte[])buffer);
            String string = StringHelper.convert(buffer);
            IOUtils.closeQuietly((InputStream)inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
            return string;
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getFingerprint: ", (Throwable)e);
            }
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
    }
}

