/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.integration.download.impl;

import com.bxm.spider.constant.exception.BaseRunException;
import com.bxm.spider.constant.monitor.ErrorEnum;
import com.bxm.spider.constant.monitor.MonitorConstant;
import com.bxm.spider.constant.monitor.MonitorDto;
import com.bxm.spider.constant.monitor.MonitorDtoHelper;
import com.bxm.spider.constant.monitor.MonitorHelper;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.download.facade.model.DownloadDto;
import com.bxm.spider.download.facade.service.DownloadFeignService;
import com.bxm.spider.prod.integration.download.DownLoadIntegrationService;
import com.bxm.spider.prod.integration.download.model.DownLoadDto;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DownLoadIntegrationServiceImpl
implements DownLoadIntegrationService {
    private Logger logger = LoggerFactory.getLogger(DownLoadIntegrationServiceImpl.class);
    @Autowired
    private DownloadFeignService downloadFeignService;

    @Override
    public MonitorDto httpDownLoad(DownLoadDto downLoadDto) {
        block7: {
            ResponseModel responseModel = ResponseModelFactory.FAILED();
            try {
                responseModel = this.downloadFeignService.download((DownloadDto)downLoadDto);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("execute download success params:{}", (Object)downLoadDto);
                }
                if (responseModel.isError()) {
                    throw new BaseRunException(responseModel.getMessage());
                }
            }
            catch (Exception e) {
                for (int i = 0; i < 3; ++i) {
                    try {
                        this.logger.warn("\u8c03\u7528\u4e0b\u8f7d\u4e2d\u5fc3\u5931\u8d25\u6b63\u5728\u91cd\u8bd5\uff01data: {}, message: {}", (Object)downLoadDto, (Object)e.getMessage());
                        responseModel = this.downloadFeignService.download((DownloadDto)downLoadDto);
                        if (!responseModel.isSuccess()) continue;
                        break;
                    }
                    catch (Exception e1) {
                        this.logger.warn("\u91cd\u8bd5\u5931\u8d25{}\u6b21\uff01data: {}, message: {}", new Object[]{i + 1, downLoadDto, e.getMessage()});
                    }
                }
                if (!responseModel.isError()) break block7;
                this.logger.error(MonitorConstant.MONITOR, "\u8c03\u7528\u4e0b\u8f7d\u4e2d\u5fc3\u5931\u8d25\uff01downLoadDto: {} {}", new Object[]{downLoadDto, MonitorHelper.ofLog((boolean)false, (String)"PROD_PROGRESS", (ProcessorParameter)downLoadDto.getProcessorParameter(), (ErrorEnum)ErrorEnum.PROD_DOWNLOAD_ERROR, (String)e.getMessage()), e});
                return MonitorDtoHelper.ofMonitorDtoFail((ProcessorParameter)downLoadDto.getProcessorParameter(), (String)e.getMessage(), (Integer)responseModel.getCode());
            }
        }
        return MonitorDtoHelper.ofMonitorDtoSuccess((ProcessorParameter)downLoadDto.getProcessorParameter());
    }

    @Override
    public MonitorDto httpDownLoadImage(DownLoadDto downLoadDto) {
        block7: {
            ResponseModel responseModel = ResponseModelFactory.FAILED();
            try {
                responseModel = this.downloadFeignService.download((DownloadDto)downLoadDto);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("execute download success params:{}", (Object)downLoadDto);
                }
                if (responseModel.isError()) {
                    throw new BaseRunException(responseModel.getMessage());
                }
            }
            catch (Exception e) {
                for (int i = 0; i < 3; ++i) {
                    try {
                        this.logger.warn("\u8c03\u7528\u4e0b\u8f7d\u4e2d\u5fc3\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25\u6b63\u5728\u91cd\u8bd5\uff01data: {}, message: {}", (Object)downLoadDto, (Object)e.getMessage());
                        responseModel = this.downloadFeignService.download((DownloadDto)downLoadDto);
                        if (!responseModel.isSuccess()) continue;
                        break;
                    }
                    catch (Exception e1) {
                        this.logger.warn("\u91cd\u8bd5\u5931\u8d25{}\u6b21\uff01data: {}, message: {}", new Object[]{i + 1, downLoadDto, e.getMessage()});
                    }
                }
                if (!responseModel.isError()) break block7;
                this.logger.error("\u8c03\u7528\u4e0b\u8f7d\u4e2d\u5fc3\u5931\u8d25\uff01{}", (Object)downLoadDto, (Object)e);
                return MonitorDtoHelper.ofMonitorDtoFail((ProcessorParameter)downLoadDto.getProcessorParameter(), (String)e.getMessage(), (Integer)responseModel.getCode());
            }
        }
        return MonitorDtoHelper.ofMonitorDtoSuccess((ProcessorParameter)downLoadDto.getProcessorParameter());
    }
}

