/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVpnConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpnConnectionsRequest>, DescribeVpnConnectionsRequest> {
    public Request<DescribeVpnConnectionsRequest> marshall(DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        SdkInternalList describeVpnConnectionsRequestFiltersList;
        if (describeVpnConnectionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpnConnectionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpnConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpnConnectionsRequestVpnConnectionIdsList = (SdkInternalList)describeVpnConnectionsRequest.getVpnConnectionIds();
        if (!describeVpnConnectionsRequestVpnConnectionIdsList.isEmpty() || !describeVpnConnectionsRequestVpnConnectionIdsList.isAutoConstruct()) {
            int vpnConnectionIdsListIndex = 1;
            for (String describeVpnConnectionsRequestVpnConnectionIdsListValue : describeVpnConnectionsRequestVpnConnectionIdsList) {
                if (describeVpnConnectionsRequestVpnConnectionIdsListValue != null) {
                    request.addParameter("VpnConnectionId." + vpnConnectionIdsListIndex, StringUtils.fromString((String)describeVpnConnectionsRequestVpnConnectionIdsListValue));
                }
                ++vpnConnectionIdsListIndex;
            }
        }
        if (!(describeVpnConnectionsRequestFiltersList = (SdkInternalList)describeVpnConnectionsRequest.getFilters()).isEmpty() || !describeVpnConnectionsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpnConnectionsRequestFiltersListValue : describeVpnConnectionsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpnConnectionsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpnConnectionsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpnConnectionsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

