package com.bxm.spider;

import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;

/**
 * 爬虫服务提供
 *
 * @author kk.xie
 * @date 2018/10/18 14:24
 */  
@MapperScan("com.bxm.spider.prod.dal.mapper")
@SpringBootApplication
@EnableDiscoveryClient
@EnableFeignClients({"com.bxm.spider.prod.facade"})
@EnableApolloConfig
public class SpiderProdApplication {
	public static void main(String[] args) {
		SpringApplication.run(SpiderProdApplication.class, args);
	}
}
