package com.bxm.spider.prod.utils;

import com.bxm.spider.constant.processor.PersistenceEnum;
import com.bxm.spider.constant.processor.PretreatmentEnum;
import com.bxm.spider.constant.processor.ProcessorEnum;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.constant.proxy.ProxyFlagEnum;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.prod.job.SpiderQueueJob;
import com.bxm.spider.prod.param.DownloadParam;
import com.bxm.spider.prod.param.LoginAccountParam;
import com.bxm.spider.prod.common.constants.Constant;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 任务工具类
 *
 * @ClassName ProdServiceUtils
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/22 15:45
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/22 15:45
 **/
public class ProdServiceUtils {

    private static Logger logger = LoggerFactory.getLogger(SpiderQueueJob.class);
    /**
     * 详情队列名称
     *
     * @param serialNum
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/10/24 20:18
     */
    public static String getDetailsJobName(String serialNum){
        return StringUtils.join(new String[] {Constant.JOB_DETAILS_HEAD, serialNum}, "_");
    }

    /**
     * 列表队列名称
     *
     * @param serialNum
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/10/24 20:19
     */
    public static String getQueueJobName(String serialNum){
        return StringUtils.join(new String[] {Constant.JOB_QUEUE_HEAD, serialNum}, "_");
    }

    public static String getJobName(String serialNum){
        return StringUtils.join(new String[] {Constant.JOB_HEAD, serialNum}, "_");
    }

    public static String getJobGroupName(String taskName){
        return StringUtils.join(new String[] {Constant.JOB_GROUP_HEAD, taskName}, "_");
    }

    public static DownloadParam ofDownloadDto(String url, String originUrl , String cookie,
                                              String userAgent, String referer, String channel,
                                              String serialNum, String urlTypeEnum, String processorEnumName,
                                              String charset, String pretreatmentParam, PretreatmentEnum pretreatmentEnum,
                                              ProxyFlagEnum proxyFlag, String persistenceType, String object, List<LoginAccountParam> LoginAccountParamList){

        try{
            DownloadParam downLoadParam = new DownloadParam();
            ProcessorParameter processorParameter = new ProcessorParameter();

            processorParameter.setSerialNum(serialNum);
            processorParameter.setUrl(StringUtils.replaceAll(url, "\\s", ""));
            processorParameter.setOriginUrl(originUrl);
            processorParameter.setType(UrlTypeEnum.valueOf(urlTypeEnum));
            processorParameter.setProcessorEnum(ProcessorEnum.valueOf(processorEnumName));
            processorParameter.setJsonObject(object);
            processorParameter.setPersistenceEnum(PersistenceEnum.valueOf(persistenceType));
            downLoadParam.setProcessorParameter(processorParameter);

            downLoadParam.setPretreatmentEnum(pretreatmentEnum);
            downLoadParam.setPretreatmentParam(pretreatmentParam);
            downLoadParam.setCharset(charset);
            downLoadParam.setUserAgent(userAgent);
            downLoadParam.setCookie(cookie);
            downLoadParam.setChannel(channel);
            downLoadParam.setReferer(referer);
            downLoadParam.setProxyFlag(proxyFlag);
            downLoadParam.setLoginAccountParams(LoginAccountParamList);
            return downLoadParam;
        }catch(Exception e){
            logger.error("ofDownloadDto error : ",e);
            return null;
        }

    }

    public static String getSaveUrl(String originUrl, String url){
        return StringUtils.join(new String[] {originUrl, url}, Constant.URL_JOINT_CHAR);
    }

}
