package com.bxm.spider.prod.job;

import com.bxm.spider.utils.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.concurrent.*;

/**
 * job专用的线程池
 *
 * @ClassName JobThreadPool
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/11/26 9:43
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/11/26 9:43
 **/
@Component
public class JobThreadPool {

    private Logger logger = LoggerFactory.getLogger(JobThreadPool.class);

    private ThreadPoolExecutor pool;

    private ScheduledExecutorService scheduled;

    private LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<>();

    public JobThreadPool() {
        pool = new ThreadPoolExecutor(10, 10, 0, TimeUnit.SECONDS,
                new LinkedBlockingQueue<>(), new NamedThreadFactory("jobPool"));

        scheduled = new ScheduledThreadPoolExecutor(3, new NamedThreadFactory("scheduledJobPool"));
        for(int i=0; i<3; i++) {
            scheduled.scheduleAtFixedRate(() -> {
                try {
                    logger.info("当前代理队列长度:[{}]",this.queue.size());
                    Runnable take = queue.take();
                    take.run();
                } catch (InterruptedException e) {
                    logger.error("定时job执行错误！", e);
                }
            }, 5000, 500, TimeUnit.MILLISECONDS);
        }
    }
    /**
     * 执行任务-返回值:普通的队列
     *
     * @param runnable
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/11/26 10:01
     */
    public void execute(Runnable runnable){
        pool.execute(runnable);
    }

    /**
     * 执行任务有返回值
     *
     * @param task
     * @return java.util.concurrent.Future<T>
     * @throws
     * @author kk.xie
     * @date 2018/11/26 10:01
     */
    public <T> Future<T> submit(Callable<T> task){
        return pool.submit(task);
    }

    /**
     * 关闭线程池
     *
     * @param
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/11/26 10:01
     */
    public void shutdown(){
        pool.shutdown();
    }

    public void executeScheduled(Runnable runnable){
        try {
            this.queue.put(runnable);
        } catch (InterruptedException e) {
            logger.error("添加任务失败!", e);
        }
    }

    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(JobThreadPool.class);
        JobThreadPool JobThreadPool = new JobThreadPool();
        for(int i= 0 ; i< 10 ; i++){
            JobThreadPool.executeScheduled(() -> logger.info(" 执行任务"));
        }

    }
}
