package com.bxm.spider.prod.job;

import com.bxm.spider.prod.model.dao.LoginAccount;
import com.bxm.spider.prod.param.LoginAccountParam;
import com.bxm.spider.prod.common.constants.Constant;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

import java.util.ArrayList;
import java.util.List;

/**
 * job 公共父类
 *
 * @ClassName ProdJob
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/11/6 10:49
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/11/6 10:49
 **/
public abstract class ProdJob implements Job {
    /**
     * 获取缓存中的用户数据
     *
     * @param context
     * @return java.util.List<com.bxm.spider.prod.model.dao.LoginAccount>
     * @throws
     * @author kk.xie
     * @date 2018/12/7 17:35
     */
    public List<LoginAccountParam> getLoginAccountParamList(JobExecutionContext context){
        try {
            Object o = context.getJobDetail().getJobDataMap().get(Constant.LOGIN_ACCOUNT_LIST);
            if(o != null){
                List<LoginAccount> loginAccountList = (List<LoginAccount>) o;
                List<LoginAccountParam> LoginAccountParamList = new ArrayList<>();
                loginAccountList.forEach(loginAccount -> {
                    LoginAccountParam LoginAccountParam = new LoginAccountParam();
                    LoginAccountParam.setLoginUrl(LoginAccountParam.getLoginUrl());
                    LoginAccountParam.setParaName(LoginAccountParam.getParaName());
                    LoginAccountParam.setUsername(LoginAccountParam.getUsername());
                    LoginAccountParam.setPassword(LoginAccountParam.getPassword());
                    LoginAccountParam.setTimeout(LoginAccountParam.getTimeout());

                    LoginAccountParamList.add(LoginAccountParam);
                });
                return LoginAccountParamList;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<>();
    }

}
