package com.bxm.spider.prod.listener;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * job listener
 *
 * @ClassName SpiderJobListener
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/23 11:03
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/23 11:03
 **/
@Component
public class SpiderJobListener implements JobListener {

    private Logger logger = LoggerFactory.getLogger(SpiderJobListener.class);

    /**
     * 返回一个字符串用以说明 JobListener 的名称
     *
     * @param
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/10/23 11:04
     */
    @Override
    public String getName() {
        return SpiderJobListener.class.getName();
    }

    /**
     * Scheduler 在 JobDetail 将要被执行时调用这个方法
     *
     * @param context
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/10/23 11:04
     */
    @Override
    public void jobToBeExecuted(JobExecutionContext context) {
        logger.info("execute jobToBeExecuted" + context.getScheduler().toString());
    }

    /**
     * Scheduler 在 JobDetail 即将被执行，但又被 TriggerListener 否决了时调用这个方法
     *
     * @param context
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/10/23 11:04
     */
    @Override
    public void jobExecutionVetoed(JobExecutionContext context) {
        logger.info("execute jobExecutionVetoed" + context.getScheduler().toString());
    }

    /**
     * Scheduler 在 JobDetail 被执行之后调用这个方法
     *
     * @param context
     * @param jobException
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/10/23 11:04
     */
    @Override
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        logger.info("execute jobWasExecuted" + context.getScheduler().toString());
    }
}
