package com.bxm.spider.cache.autoconfigure;

import org.springframework.boot.context.properties.ConfigurationProperties;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;

/**
 * <p> redis的配置类 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/10/20
 */
@ConfigurationProperties(prefix = "spider.redis")
public class RedisConfiguration extends JedisPoolConfig {

     //测试用地址
//    private String host = "10.10.1.42";
//    private String password = "redis_pwd123";
//    private int port = 6379;
//    private int timeout = Protocol.DEFAULT_TIMEOUT;
//    private int database = 1;

    private String host = Protocol.DEFAULT_HOST;
    private String password;
    private int port = Protocol.DEFAULT_PORT;
    private int timeout = Protocol.DEFAULT_TIMEOUT;
    private int database = Protocol.DEFAULT_DATABASE;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getDatabase() {
        return database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }
}
