package com.bxm.spider.cache.constant;

import com.bxm.spider.cache.KeyBuilder;

/**
 * <p>
 *     马甲号redis-key 常量维护
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/3/11
 */
public class WaistcoatKeyConstant {
    private static final String SET = "SET";
    /**
     * 微信公众号相关
     */
    private static final String WECHAT = "WECHAT";
    private static final String ACCOUNT = "ACCOUNT";
    private static final String NO_ADS = "NOADS";

    /**
     * 马甲号
     */
    // 来源马甲号
    public static final  String SOURCE = "SOURCE";
    // 昵称马甲
    public static final  String NICKNAME = "NICKNAME";
    // 头像马甲
    public static final  String HEADIMG = "HEADIMG";
    /**
     * 微信账号地区编码key
     * @date: 2019/3/11
     * @param 
     * @return java.lang.String
     * @throws 
     */
    public static String getWeChatAccountKey(){
        return KeyBuilder.build(SET,WECHAT,ACCOUNT);
    }
    /**
     * 无广告微信账号白名单
     * @date: 2019/3/11
     * @param 
     * @return java.lang.String
     * @throws 
     */
    public static String getWeChatNoAdsKey(){
        return KeyBuilder.build(SET,WECHAT,NO_ADS,ACCOUNT);
    }

    /**
     * 奇趣类新闻 默认来源set
     *
     * @param serialNum
     * @return
     */
    public static String getSourceSetKey(String serialNum){return KeyBuilder.build(SET,SOURCE, serialNum);}
    /**
     * 获取昵称马甲key
     * @date: 2019/3/11
     * @param 
     * @return java.lang.String
     * @throws 
     */
    public static String getNicknameSetKey(){return KeyBuilder.build(SET,NICKNAME);}
    /**
     * 获取头像马甲 key
     * @date: 2019/3/11
     * @param 
     * @return java.lang.String
     * @throws 
     */
    public static String getHeadImgSetKey(){return KeyBuilder.build(SET,HEADIMG);}
}
