package com.bxm.spider.cache.autoconfigure;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * <p> redis 客户端自动装配 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/10/20
 */
@Configuration
@EnableConfigurationProperties(RedisConfiguration.class)
public class RedisAutoConfiguration {

    private final RedisConfiguration redisConfig;

    public RedisAutoConfiguration(RedisConfiguration redisConfiguration){
        this.redisConfig = redisConfiguration;
    }

    @Bean
    public JedisPool jedisPool(){
        return new JedisPool(redisConfig,redisConfig.getHost(),redisConfig.getPort(),redisConfig.getTimeout(),
                redisConfig.getPassword(),redisConfig.getDatabase());
    }

}
