package com.bxm.spider.cache.constant;

import com.bxm.spider.cache.KeyBuilder;

/**
 * <p> 去重数据相关redis常量 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/2/27
 */
public class RepeatKeyConstant {
    private static final String REPEAT = "REPEAT";
    /**
     * 新闻视频去重key
     */
    private static final String NEWSVIDEO = "NEWSVIDEO";
    public static final int EXPIRE_NEWSVIDEO = 10*24*60*60;

    /**
     * 获取新闻视频redis 去重key
     * @date: 2019/2/27
     * @param dateStr
     * @return java.lang.String
     * @throws 
     */
    public static String getNewsVideoRepeatKey(String dateStr){
        return getRepeatKey(NEWSVIDEO,dateStr);
    }

    public static String getRepeatKey(String key,String dateStr){
        return KeyBuilder.build(REPEAT,key,dateStr);
    }

}
