package com.bxm.spider.cache.constant;

import com.bxm.spider.cache.KeyBuilder;

/**
 * <p> 保存simhash的key常量 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/12/14
 */
public class SimHashConstant {
    private static final String SIMHASH_REPEAT= "REPEAT:SIMHASN";
    public static final String SIMHASH_TITLE = "TITLE";
    public static final String SIMHASH_CONTENT = "CONTENT";
    private static final String SIMHASH_TOTAL = "TOTAL";
    private static final String REPEAT_TIMES = "TIMES";
    public static final int EXPIRE_SIMHASH = 15*24*60*60;

    /**
     * 根据日期获取 title simHash 的redis key值
     * @date: 2018/12/14
     * @param date
     * @return java.lang.String
     * @throws 
     */
    public static String simHashTitleKey(String date){
        return KeyBuilder.build(SIMHASH_REPEAT,date,SIMHASH_TITLE);
    }
    /**
     * 根据日期获取 content simHash 的redis key值
     * @date: 2019/1/3
     * @param date
     * @return java.lang.String
     * @throws 
     */
    public static String simHashContentKey(String date){
        return KeyBuilder.build(SIMHASH_REPEAT,date,SIMHASH_CONTENT);
    }
    /**
     * 最近15天title得hashCode key
     * @date: 2019/1/10
     * @param 
     * @return java.lang.String
     * @throws 
     */
    public static String simHashTitleTotalKey() {
        return KeyBuilder.build(SIMHASH_REPEAT,SIMHASH_TOTAL,SIMHASH_TITLE);
    }
    /**
     * 最近15天content得simHash汇总key
     * @date: 2019/2/18
     * @param shortSimHash
     * @return java.lang.String
     * @throws 
     */
    public static String simHashContentTotalKey(String shortSimHash) {
        return KeyBuilder.build(SIMHASH_REPEAT,SIMHASH_TOTAL,SIMHASH_CONTENT,shortSimHash);
    }
    public static String simHashRepeatTimesKey(){
        return KeyBuilder.build(SIMHASH_REPEAT,REPEAT_TIMES);
    }
}
