package com.bxm.spider.cache.constant;

import com.bxm.spider.cache.KeyBuilder;

/**
 * <p> 任务调度应用之间常用的 key 常量维护类 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/10/20
 */
public class TaskKeyConstant {

    /**
     * 待下载和已下载队列
     */
    public static final  String URL = "URL";
    public static final  String QUEUE = "QUEUE";
    public static final  String DETAIL = "DETAIL";
    public static final  String IMAGE = "IMAGE";
    public static final  String CATCH = "CATCH";
    public static final  String TASK = "TASK";
    public static final  String DEPTH = "DEPTH";
    public static final  String OBJECT = "OBJECT";
    public static final  String EXECUTING = "EXECUTING";


    /**
     * 详情url 在redis 缓存的时间
     */
    public static final int URL_DETAIL_EXPIRE = 60 * 60 * 24 * 2;

    /**
     * 列表队列 redis key (list)
     *
     * @param serialNum 流水号
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/10/22 10:51
     */
    public static String getQueueList(String serialNum){return KeyBuilder.build(URL, QUEUE, serialNum);}

    /**
     * 详情队列redis key (list)
     *
     * @param serialNum 流水号
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/10/22 10:52
     */
    public static String getDetailList(String serialNum){return KeyBuilder.build(URL, DETAIL, serialNum);}

    /**
     * 任务执行的缓存 url (set) 记录任务执行已爬取的url集，配置过期时间为1个月
     *
     * @param serialNum
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/10/22 14:22
     */
    public static String getCatchSet(String serialNum){return KeyBuilder.build(URL, CATCH, TASK, serialNum);}
    /**
     * 已下载的图片队列 redis key(set)
     * @date: 2018/11/19
     * @param serialNum
     * @return java.lang.String
     * @throws
     */
    public static String getImageCatchSet(String serialNum){return KeyBuilder.build(URL, CATCH, IMAGE, serialNum);}
    /**
     * 列表url爬取深度缓存 单周期内有效 (hash)
     *
     * @param serialNum
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/10/25 15:29
     */
    public static String getDepthCatchHash(String serialNum){return KeyBuilder.build(URL, CATCH, DEPTH, serialNum);}

    /**
     * 列表队列爬取记录缓存 单周期内有效 (Set)
     *
     * @param serialNum
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/10/25 15:31
     */
    public static String getQueueCatchSet(String serialNum){return KeyBuilder.build(URL, CATCH, QUEUE, serialNum);}

    /**
     * 爬取流程中每次请求都可以绑定参数到这个redis key 中
     * key: URL:CATCH:OBJECT:serialNum
     * field: url的hashcode值
     * value:json格式的参数对象
     *
     * @param serialNum
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/11/20 10:51
     */
    public static String getUrlObjectHash(String serialNum){return KeyBuilder.build(URL, CATCH, OBJECT, serialNum);}

    /**
     * 执行中的任务
     *
     * @return java.lang.String
     * @throws
     * @author kk.xie
     * @date 2018/11/28 14:36
     */
    public static String getTaskExecutingHash(){return KeyBuilder.build(TASK, EXECUTING);}

}
