package com.bxm.spider.oss.service;

import com.bxm.spider.oss.model.ImageModel;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.InputStream;

/**
 * @author: zhaoyadong 2018/9/13 17:10
 */
public interface AliYunOssService {
    /**
     * 根据图片url上传到oss服务器上
     * @param url 图片原url
     * @param pathName oos图片路径
     * @param suffix oos图片url 后缀
     * @return
     */
    String getOssUrl(String url, String pathName, String suffix);
    /**
     * 根据图片url上传到oss服务器上
     * @param url
     * @param pathName
     * @return
     */
    String getOssUrl(String url, ImageModel imageModel, String pathName);

    /**
     * 根据url 获取图片信息
     * @param url
     * @param pathName
     * @param isQRCodeEnable
     * @return
     */
    ImageModel getImageInfo(String url, String pathName, boolean isQRCodeEnable);

    /**
     * 功能说明：文件名如果存在则会覆盖以前的文件<br/>
     * 多文件上传到OSS
     * @param multipartFiles 上传路径系统自定义 路径为：{contentType}/{yyyyMMdd}/{fileName}
     * @return 上传成功返回所有链接地址的数组
     */
    String[] upload(MultipartFile... multipartFiles);

    /**
     * 接收前端提交的文件上传到oss
     * @param multipartFile 上传文件
     * @return oss上的存储链接
     */
    String upload(MultipartFile multipartFile);

    /**
     *
     * 接收前端提交的文件上传到oss
     * @param multipartFile 上传文件
     * @param path 上传路径
     * @return oss上的存储链接
     */
    String upload(MultipartFile multipartFile, String path);

    /**
     * 功能说明：文件名如果存在则会覆盖以前的文件<br/>
     * 多文件上传到OSS.
     * @param files 上传路径系统自定义 路径为：{contentType}/{yyyyMMdd}/{fileName}
     * @return 上传成功返回所有链接地址的数组
     */
    String[] upload(File... files);

    /**
     * 上传file到OSS.<br/>
     * @param file 本地文件
     * @param path 1.空字符串或null，将自动创建路径，默认路径为{contentType}/{yyyyMMdd}/{fileName}
     *             2.路径仅包含文件名，自动创建根目录，路径为{contentType}/{yyyyMMdd}/{path}
     *             3.包含路径和文件名，直接使用参数
     *             4.路径以分隔符结束，创建随机的文件名{uuid}.{contentType} 路径为：{path}/{uuid}.{contentType}
     * @return 上传成功返回链接地址，上传失败返回为null
     */
    String upload(File file, String path);

    /**
     * 上传流到阿里云
     * @param stream 文件流
     * @param path   上传后的存放路径
     * @return 阿里云的存放路径
     */
    String upload(InputStream stream, String path);

    /**
     * 功能说明：文件名如果存在则会覆盖以前的文件<br/>
     * 上传Object到OSS.<br/>
     * @param data 字节数组数据
     * @param path 1.空字符串或null，将自动创建路径，默认路径为{contentType}/{yyyyMMdd}/{fileName}
     *             2.路径仅包含文件名，自动创建根目录，路径为{contentType}/{yyyyMMdd}/{path}
     *             3.包含路径和文件名，直接使用参数
     *             4.路径以分隔符结束，创建随机的文件名{uuid}.{contentType} 路径为：{path}/{uuid}.{contentType}
     * @return 上传成功返回链接地址，上传失败返回为null
     */
    String upload(byte[] data, String path);

    /**
     * 下载阿里云的文件.<br/>
     * @param path     阿里云文件路径
     *                 下载文件的后缀名为开头：
     *                 例如 下载的地址为:https://bxm-news.oss-cn-hangzhou.aliyuncs.com/localnews_test/txt/yyyyMMdd/xxx.txt
     *                 path则为：/txt/yyyyMMdd/xxx.txt
     *                 <br/>
     * @param filePath 本地文件路径
     * @return 下载是否成功
     */
    Boolean download(String path, String filePath);

    /**
     * 获取oss中文件的根目录（根据配置会有变化）
     * 具体路径规则：https://{bucket}.{endpoint}/{folder}
     * @return oss文件存储根目录
     */
    String getOSSFileRoot();

}
