package com.bxm.spider.multipage;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName MultiPageUtils.java
 * @Description 功能描述：多表分页计算方法
 * @author stephen 2018年12月29日 下午1:56:28
 * @CopyRight 杭州微财网络科技有限公司
 */
public class MultiPageUtils {

    /**
     * 多表分页条件计算
     *
     * @param currentPage 当前页
     * @param pageSize 每页数量
     * @param countArr 各分表符合条件的数量数组
     * @return 条件列表
     */
    public static List<MultiPageParam> calPage(int currentPage, int pageSize, int[] countArr) {
        if (currentPage < 1) {
            currentPage = 1;
        }

        int start = (currentPage - 1) * pageSize;
        int end = currentPage * pageSize;

        int count = 0;
        Integer startSuffix = -1;
        Integer endSuffix = -1;
        for (int i = 0; i < countArr.length; i++) {
            count += countArr[i];
            if (-1 == startSuffix && count > start) {
                startSuffix = i;
                start = countArr[i] - (count - start);
            }
            if (count > end) {
                endSuffix = i;
                end = end - (count - countArr[i]);
                break;
            }
        }

        //实际条数小于请求结束条数
        if (-1 == endSuffix) {
            endSuffix = startSuffix;
        }

        List<MultiPageParam> pageConditions = new ArrayList<>();

        if (startSuffix != -1) {
            if (startSuffix == endSuffix) {
                MultiPageParam page = new MultiPageParam();
                page.setSuffix(startSuffix.toString());
                page.setCurrent(start);
                page.setSize(pageSize);
                pageConditions.add(page);
            } else {
                MultiPageParam page = new MultiPageParam();
                page.setSuffix(startSuffix.toString());
                page.setCurrent(start);
                page.setSize(pageSize);
                pageConditions.add(page);
                for (Integer i = startSuffix + 1; i < endSuffix; i++) {
                    page = new MultiPageParam();
                    page.setSuffix(i.toString());
                    page.setCurrent(0);
                    page.setSize(pageSize);
                    pageConditions.add(page);
                }
                page = new MultiPageParam();
                page.setSuffix(endSuffix.toString());
                page.setCurrent(0);
                page.setSize(end);
                pageConditions.add(page);
            }
        }

        return pageConditions;
    }

}
