package com.bxm.spider.utils;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.net.URL;

public class ImageUtils {

    public static void main(String[] args) {
        String ossUrl="https://mmbiz.qpic.cn/mmbiz_jpg/7hxJRjsnhfn5L6sObqdf1VTVSeSHIrrgpWMbeDO8MJSqkkE3Iw2eTfZBc8AouHc3NP1UYh3xiavcfIfgMvVEY6A/640?";
        BufferedImage bi = ImageUtils.readFromUrl(ossUrl);
        System.out.println(ImageUtils.isQRCode(bi));
    }

    /**
     * 从图片url中读取图片
     * @param url
     * @return
     */
    public static BufferedImage readFromUrl(String url) {
        try {
            return ImageIO.read(new URL(url));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 判断图片是否包含二维码
     * @param image
     * @return
     */
    public static boolean isQRCode(BufferedImage image) {
        if (null == image) {
            return false;
        }
        try {
            image = toGrayscale(image);
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            BinaryBitmap binaryBitmap = new BinaryBitmap(new HybridBinarizer(new BufferedImageLuminanceSource(image)));
            multiFormatReader.decode(binaryBitmap);
            return true;
        } catch (Exception e) {
            //e.printStackTrace();
            return false;
        }
    }

    /**
     * 图片灰度转换
     * @return
     */
    public static BufferedImage toGrayscale(BufferedImage image){
        BufferedImage changeImage = new BufferedImage(image.getWidth(),image.getHeight(),image.getType());
        changeImage.setData(image.getData());
        int width = changeImage.getWidth();
        int height = changeImage.getHeight();

        for (int j = 0; j < height; j++) {
            for (int i = 0; i < width; i++) {
                int p = changeImage.getRGB(i, j);

                int a = (p >> 24) & 0xff;
                int r = (p >> 16) & 0xff;
                int g = (p >> 8) & 0xff;
                int b = p & 0xff;

                int avg = (r + g + b) / 3;

                p = (a << 24) | (avg << 16) | (avg << 8) | avg;

                changeImage.setRGB(i, j, p);
            }
        }
        return changeImage;
    }

}
