package com.bxm.spider.utils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author stephen 2019年1月18日 下午1:56:28
 * @ClassName MultiTableUtils.java
 * @Description 功能描述：多表相关方法
 * @CopyRight 杭州微财网络科技有限公司
 */
public class MultiTableUtils {
    private static final String NEWS = "news_";
    private static final String WECHATNEWS = "wechat_news_";
    private static final String NEWSWECHAT = "news_wechat";
    private static final String COUPON = "coupon_goods";
    private static final String VIDEO = "video";
    private static final String COMPANY = "zhaopin_company";
    private static final String WORK = "zhaopin_work";

    public static List<String> getAllTableList() {
        List<String> resultList = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            resultList.add(NEWS + i);
        }
        for (int i = 0; i < 10; i++) {
            resultList.add(WECHATNEWS + i);
        }
        resultList.add(NEWSWECHAT);
        resultList.add(COUPON);
        resultList.add(VIDEO);
        resultList.add(COMPANY);
        resultList.add(WORK);

        return resultList;
    }

    /**
     * 构造news多表列表
     */
    public static List<String> getNewsTableList() {
        List<String> resultList = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            resultList.add(NEWS + i);
        }

        return resultList;
    }

    /**
     * 构造wechatnews多表列表
     */
    public static List<String> getFullWechatNewsTableList() {
        List<String> resultList = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            resultList.add(WECHATNEWS + i);
        }
        resultList.add(NEWSWECHAT);

        return resultList;
    }


    /**
     * 构造纯wechatnews多表列表
     */
    public static List<String> getWechatNewsTableList() {
        List<String> resultList = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            resultList.add(WECHATNEWS + i);
        }

        return resultList;
    }
}
