package com.bxm.spider.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * <p> 自定义字符串处理工具方法 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/11/22
 */
public class StringHelps {
    public static final char[] DIGITS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static final char[] DIGITS_NOCASE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static void main(String[] args) {
        String json = updateJsonObject(null,"a","a");
        json = updateJsonObject(json,"b","b");
        System.out.println(json);
    }
    /**
     * jsonString 数据更新，没有则新建
     * @date: 2018/11/22
     * @param oldJson
     * @param newKey
     * @param newValue
     * @return java.lang.String
     * @throws
     */
    public static String updateJsonObject(String oldJson, String newKey, Object newValue) {
        JSONObject jsonObject = JSONObject.parseObject(oldJson);
        if(null == jsonObject){
            jsonObject = new JSONObject();
        }
        jsonObject.put(newKey,newValue);
        return jsonObject.toJSONString();
    }

    /**
     * 从 jsonObject 中获取 key 对应的 value值
     * @date: 2018/12/26
     * @param jsonObject
     * @param key
     * @return java.lang.Object
     * @throws 
     */
    public static Object getFromJsonObject(String jsonObject,String key){
        if(StringUtils.isBlank(jsonObject) || StringUtils.isBlank(key)){
            return null;
        }
        JSONObject json = JSONObject.parseObject(jsonObject);
        return json.get(key);
    }

    /**
     * 将一个byte数组转换成62进制的字符串。
     * @param bytes  源数组
     * @param noCase 是否采用小写字母
     */
    public static String bytesToString(byte[] bytes, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;

        if (ArrayUtils.isEmpty(bytes)) {
            return String.valueOf(digits[0]);
        }

        StringBuilder strValue = new StringBuilder();
        int value = 0;
        int limit = Integer.MAX_VALUE >>> 8;
        int i = 0;

        do {
            while (i < bytes.length && value < limit) {
                value = (value << 8) + (0xFF & bytes[i++]);
            }

            while (value >= digitsLength) {
                strValue.append(digits[value % digitsLength]);
                value = value / digitsLength;
            }
        } while (i < bytes.length);

        if (value != 0 || strValue.length() == 0) {
            strValue.append(digits[value]);
        }

        return strValue.toString();
    }

    /**
     * 将一个长整形转换成62进制的字符串。
     */
    public static String longToString(long longValue, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;

        if (longValue == 0) {
            return String.valueOf(digits[0]);
        }

        if (longValue < 0) {
            longValue = -longValue;
        }

        StringBuilder strValue = new StringBuilder();

        while (longValue != 0) {
            int digit = (int) (longValue % digitsLength);
            longValue = longValue / digitsLength;

            strValue.append(digits[digit]);
        }

        return strValue.toString();
    }
}
