package com.bxm.spider.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName UrlHelps
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/2/18 10:18
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/2/18 10:18
 **/
public class UrlHelps {

    /**
     * 从url中获取某个参数
     * @param url
     * @param paramName
     * @return
     */
    public static String getUrlParam(String url,String paramName){
        try {
            Map<String, String> paramMap = getParamMap(url);
            return paramMap.get(paramName);
        } catch (MalformedURLException e) {
           return "";
        }
    }


    /**
     * 从url中获取参数map
     *
     * @param listUrl
     * @return
     * @throws MalformedURLException
     */
    public static Map<String, String> getParamMap(String listUrl) throws MalformedURLException {
        Map<String, String> paramMap = new HashMap<>();
        URL url = new URL(listUrl);
        String[] params = url.getQuery().split("&");
        for (String param : params) {
            String[] ps = param.split("=");
            if (ps.length == 2) {
                String key = ps[0];
                String value = ps[1];
                paramMap.put(key, value);
            }
        }
        return paramMap;
    }


    /**
     * 删除所有参数
     * @return
     */
    public static String removeAllParam(String url) {
        if (!url.contains("?")){
            return url;
        }
        String[] temps = url.split("\\?");
        if (temps.length ==2){
            return temps[0];
        }
        return "";
    }


    /**
     * 从url中移除某个参数
     * @param url
     * @param paramName
     * @return
     */
    public static String removeParamByName(String url,String paramName){
        try {
            Map<String, String> paramMap = getParamMap(url);
            paramMap.remove(paramName);
            url = removeAllParam(url);
            StringBuffer sbUrl = new StringBuffer(url);
            for (String key:paramMap.keySet()){
                sbUrl.append("?").append(key).append("=").append(paramMap.get(key)).append("&");
            }
            return sbUrl.substring(0,sbUrl.length()-1).toString();
        } catch (MalformedURLException e) {
            return "";
        }

    }

    public static String updateParamByName(String url,String paramName,String newParamValue){
        String param = getUrlParam(url,paramName);
        return url.replace(paramName+"="+param,paramName+"="+newParamValue);
    }

    public static void main(String[] args) {
        System.out.println(updateParamByName("http://api.9idudu.com/sdk/default/app/share/share.html?appId=LIU_DA&messageId=b0275b430b32d22&messageType=NEWS&parentId=18ada204dd1f156540fb3ba275a41fe7&rt=channel&page=1&tk=18ada204dd1f156540fb3ba275a41fe7","page","2"));
    }
}
