package com.bxm.warcar.cache.autoconfigure.jedis;

import com.bxm.warcar.cache.redis.JedisFetcher;
import com.bxm.warcar.cache.redis.JedisSerializationFetcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(JedisConfiguration.class)
public class JedisFetcherAutoConfiguration {

    @Autowired
    private JedisConfiguration configuration;

    @Bean
    public JedisPool jedisPool() {
        return new JedisPool(configuration, configuration.getHost(), configuration.getPort(), configuration.getTimeout(), configuration.getPassword(), configuration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcher() {
        return new JedisFetcher(jedisPool());
    }

    @Bean
    public JedisSerializationFetcher jedisSerializationFetcher() {
        return new JedisSerializationFetcher(jedisPool());
    }
}
