/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.autoconfigure.jedis;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.cache.impls.redis.DistributedRedisLock;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisLock;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import com.bxm.warcar.xcache.fetchers.RedisFetcher;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.JedisPool;

@EnableConfigurationProperties(value={JedisConfiguration.class})
public class JedisAutoConfiguration {
    @Autowired
    private JedisConfiguration configuration;

    @Bean
    @Primary
    public JedisPool jedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.configuration, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getTimeout(), this.configuration.getPassword(), this.configuration.getDatabase());
    }

    @Bean
    @Primary
    public JedisFetcher jedisFetcher(JedisPool jedisPool) {
        return new JedisFetcher(jedisPool);
    }

    @Bean
    @Primary
    public JedisUpdater jedisUpdater(JedisPool jedisPool) {
        return new JedisUpdater(jedisPool);
    }

    @Bean
    @Primary
    public JedisCounter jedisCounter(JedisPool jedisPool) {
        return new JedisCounter(jedisPool);
    }

    @Bean
    public JedisLock jedisLock(JedisPool jedisPool) {
        return new JedisLock(jedisPool);
    }

    @Bean
    public RedisFetcher redisFetcher(JedisPool jedisPool) {
        return new RedisFetcher(jedisPool);
    }

    @Bean
    @Primary
    public LoadingCacheFetcher loadingCacheFetcher(JedisPool jedisPool) {
        return new LoadingCacheFetcher((Fetcher)this.redisFetcher(jedisPool));
    }

    @Bean
    public DistributedRedisLock distributedRedisLock(JedisPool jedisPool) {
        return new DistributedRedisLock(jedisPool);
    }
}

