package com.bxm.warcar.cache.autoconfigure.jedis;

import com.bxm.warcar.cache.impls.redis.*;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import com.bxm.warcar.xcache.fetchers.RedisFetcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.JedisPool;

@EnableConfigurationProperties(JedisConfiguration.class)
public class JedisAutoConfiguration {

    @Autowired
    private JedisConfiguration configuration;

    @Bean
    @Primary
    public JedisPool jedisPool() {
        return new JedisPool(configuration, configuration.getHost(), configuration.getPort(), configuration.getTimeout(), configuration.getPassword(), configuration.getDatabase());
    }

    @Bean
    @Primary
    public JedisFetcher jedisFetcher(JedisPool jedisPool) {
        return new JedisFetcher(jedisPool);
    }

    @Bean
    @Primary
    public JedisUpdater jedisUpdater(JedisPool jedisPool) {
        return new JedisUpdater(jedisPool);
    }

    @Bean
    @Primary
    public JedisCounter jedisCounter(JedisPool jedisPool) {
        return new JedisCounter(jedisPool);
    }

    @Bean
    public JedisLock jedisLock(JedisPool jedisPool) {
        return new JedisLock(jedisPool);
    }

    @Bean
    public RedisFetcher redisFetcher(JedisPool jedisPool) {
        return new RedisFetcher(jedisPool);
    }

    @Bean
    @Primary
    public LoadingCacheFetcher loadingCacheFetcher(JedisPool jedisPool) {
        return new LoadingCacheFetcher(redisFetcher(jedisPool));
    }

    @Bean
    public DistributedRedisLock distributedRedisLock(JedisPool jedisPool) {
        return new DistributedRedisLock(jedisPool);
    }
}
