package com.bxm.warcar.datasync.autoconfigure;

import com.bxm.warcar.datasync.source.redis.RedisSourceController;
import org.springframework.boot.context.properties.ConfigurationProperties;


/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
@ConfigurationProperties(prefix = DataSyncProperties.PREFIX)
public class DataSyncProperties {

    public static final String PREFIX = "warcar.datasync";
    public static final String PROPERTY_CLIENT = PREFIX + "." + "client";
    public static final String PROPERTY_SERVER = PREFIX + "." + "server";

    private Redis redis = new Redis();

    public Redis getRedis() {
        return redis;
    }

    public void setRedis(Redis redis) {
        this.redis = redis;
    }

    public static class Redis {

        private String prefix = RedisSourceController.DEFAULT_PREFIX_KEY;
        private int db = 0;

        public String getPrefix() {
            return prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public int getDb() {
            return db;
        }

        public void setDb(int db) {
            this.db = db;
        }
    }
}
