package com.bxm.warcar.datasync.autoconfigure;

import com.bxm.warcar.datasync.server.sync.zk.ZkSyncController;
import com.bxm.warcar.zk.ZkClientHolder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
@Configuration
@ConditionalOnProperty(value = DataSyncProperties.PROPERTY_SERVER, havingValue = "true")
public class SyncControllerAutoConfiguration {

    @ConditionalOnClass(ZkClientHolder.class)
    @Bean
    public ZkSyncController zkSyncController(ZkClientHolder zkClientHolder) {
        return new ZkSyncController(zkClientHolder);
    }
}
