package com.bxm.warcar.datasync.autoconfigure.client;

import com.bxm.warcar.datasync.autoconfigure.DataSyncProperties;
import com.bxm.warcar.datasync.client.Action;
import com.bxm.warcar.datasync.client.Trigger;
import com.bxm.warcar.datasync.client.triggers.zk.ZkChildrenChangedListener;
import com.bxm.warcar.datasync.server.sync.zk.ZkSyncController;
import com.bxm.warcar.datasync.source.SourceController;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.listener.children.ChildrenChanged;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
@Configuration
@ConditionalOnClass({Action.class, SourceController.class})
@ConditionalOnProperty(value = DataSyncProperties.PROPERTY_CLIENT, havingValue = "true")
public class TriggerAutoConfiguration {

    @Bean
    public Trigger zkChildrenChangedListener(Action action, SourceController sourceController) {
        return new ZkChildrenChangedListener(action, sourceController);
    }

    @Bean(initMethod = "init", destroyMethod = "destroy")
    @ConditionalOnClass({ZkClientHolder.class, ZkChildrenChangedListener.class})
    public ChildrenChanged childrenChanged(ZkClientHolder zk, ZkChildrenChangedListener zkChildrenChangedListener) {
        return new ChildrenChanged(zk, ZkSyncController.DEFAULT_PREFIX_PATH, zkChildrenChangedListener);
    }
}
