package com.bxm.warcar.datasync.autoconfigure;

import com.bxm.warcar.datasync.server.sync.zk.ZkSyncController;
import com.bxm.warcar.zk.ZkClientHolder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
@ConditionalOnProperty(value = DataSyncProperties.PROPERTY_SERVER, havingValue = "true")
public class SyncControllerAutoConfiguration {

    private final DataSyncProperties properties;

    public SyncControllerAutoConfiguration(DataSyncProperties properties) {
        this.properties = properties;
    }

    @ConditionalOnClass(ZkClientHolder.class)
    @Bean
    public ZkSyncController zkSyncController(ZkClientHolder zkClientHolder) {
        return new ZkSyncController(zkClientHolder, properties.getZkSyncPath());
    }
}
