/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.autoconfigure;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.datasync.autoconfigure.DataSyncProperties;
import com.bxm.warcar.datasync.source.redis.RedisSourceController;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

@EnableConfigurationProperties(value={DataSyncProperties.class, JedisConfiguration.class})
public class SourceControllerAutoConfiguration {
    private final DataSyncProperties dataSyncProperties;
    private final JedisConfiguration jedisConfiguration;

    public SourceControllerAutoConfiguration(DataSyncProperties dataSyncProperties, JedisConfiguration jedisConfiguration) {
        this.dataSyncProperties = dataSyncProperties;
        this.jedisConfiguration = jedisConfiguration;
    }

    @Bean
    public RedisSourceController redisSourceController() {
        DataSyncProperties.Redis redis = this.dataSyncProperties.getRedis();
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)this.jedisConfiguration, this.jedisConfiguration.getHost(), this.jedisConfiguration.getPort(), this.jedisConfiguration.getTimeout(), this.jedisConfiguration.getPassword(), this.jedisConfiguration.getDatabase());
        return new RedisSourceController(jedisPool, redis.getPrefix(), redis.getDb());
    }
}

