package com.bxm.warcar.datasync.autoconfigure.client;

import com.bxm.warcar.datasync.autoconfigure.DataSyncProperties;
import com.bxm.warcar.datasync.client.cache.ConcurrentHashMapCacheImpl;
import com.bxm.warcar.datasync.client.cache.MutableCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
@ConditionalOnProperty(value = DataSyncProperties.PROPERTY_CLIENT, havingValue = "true")
public class CacheAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(MutableCache.class)
    public MutableCache concurrentHashMapMutableCache() {
        return new ConcurrentHashMapCacheImpl();
    }
}
