/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl.autoconfigure;

import com.bxm.warcar.dpl.autoconfigure.DplProperties;
import com.bxm.warcar.dpl2.DefaultPluginBus;
import com.bxm.warcar.dpl2.PluginBus;
import com.bxm.warcar.dpl2.dir.DefaultPluginChangedListener;
import com.bxm.warcar.dpl2.dir.PluginChangedListener;
import com.bxm.warcar.dpl2.dir.PluginDirMonitor;
import com.bxm.warcar.dpl2.plugin.PluginLoader;
import com.bxm.warcar.dpl2.plugin.spring.SpringPluginLoader;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={DplProperties.class})
public class DplAutoConfiguration {
    private final DplProperties properties;

    public DplAutoConfiguration(DplProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={PluginLoader.class})
    public PluginLoader pluginLoader(ApplicationContext applicationContext) {
        return new SpringPluginLoader(this.properties.getBasePackageToScanOfPlugin(), applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={PluginBus.class})
    public PluginBus pluginBus() {
        return new DefaultPluginBus();
    }

    @Bean
    @ConditionalOnMissingBean(value={PluginChangedListener.class})
    public PluginChangedListener pluginChangedListener(PluginBus pluginBus, PluginLoader pluginLoader) {
        return new DefaultPluginChangedListener(pluginBus, pluginLoader);
    }

    @Bean
    public PluginDirMonitor pluginDirMonitor(PluginChangedListener listener) {
        return new PluginDirMonitor(listener, this.properties.getPluginDir());
    }
}

