package com.bxm.warcar.file.autoconfigure;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.alioss.AliOssHttpFileManager;

/**
 * <h3>文件上传配置</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/01/29 09:50
 */
@Configuration
@EnableConfigurationProperties(HttpFileConfiguration.class)
public class HttpFileAutoConfiguration {

	@Autowired
	private HttpFileConfiguration httpFileConfiguration;

	@Bean
	//@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
	public HttpFileManager httpFileManager() {
		return new AliOssHttpFileManager(httpFileConfiguration.getEndPoint(),
				httpFileConfiguration.getAccessKeyId(),
				httpFileConfiguration.getAccessKeySecret(),
				httpFileConfiguration.getHost(),
				httpFileConfiguration.getBucketName(),
				httpFileConfiguration.getServiceName(),
				httpFileConfiguration.getLimitSize());
	}

}
