package com.bxm.warcar.integration.autoconfigure.eventbus;

import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
public class EventParkAutoConfiguration {

    @Bean(name = { "eventPark", "asyncEventPark" })
    @Primary
    public EventPark eventPark() {
        return new AsyncEventPark();
    }

    @Bean
    public EventPark syncEventPark() {
        return new SyncEventPark();
    }
}
