/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.autoconfigure.eventbus;

import com.bxm.warcar.integration.autoconfigure.eventbus.EventParkProperties;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import com.bxm.warcar.integration.eventbus.monitor.AsyncEventParkMonitor;
import com.bxm.warcar.message.MessageSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={EventParkProperties.class})
public class EventParkAutoConfiguration {
    private final EventParkProperties properties;

    public EventParkAutoConfiguration(EventParkProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"eventPark", "asyncEventPark"})
    @Primary
    public AsyncEventPark eventPark() {
        return new AsyncEventPark(this.properties.getAsyncEventBusPoolSize());
    }

    @Bean
    public SyncEventPark syncEventPark() {
        return new SyncEventPark();
    }

    @Bean(initMethod="init", destroyMethod="destroy")
    public AsyncEventParkMonitor asyncEventParkMonitor(@Autowired(required=false) MessageSender messageSender) {
        if (!this.properties.isAsyncEventBusAlarmEnable()) {
            return null;
        }
        return new AsyncEventParkMonitor(this.eventPark(), this.properties.getAsyncEventBusAlarmBlockQueueSize(), messageSender);
    }
}

