/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.autoconfigure.http;

import com.bxm.warcar.integration.autoconfigure.http.HttpPoolProperties;
import com.bxm.warcar.utils.http.HttpPool;
import com.bxm.warcar.utils.http.pool.HttpClientPool;
import com.bxm.warcar.utils.http.pool.OkHttpPool;
import com.bxm.warcar.utils.http.pool.RestTemplatePool;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@EnableConfigurationProperties(value={HttpPoolProperties.class})
public class HttpPoolAutoConfiguration {
    private final HttpPoolProperties properties;

    public HttpPoolAutoConfiguration(HttpPoolProperties properties) {
        this.properties = properties;
    }

    @Primary
    @Bean
    public HttpPool httpClientPool() {
        return new HttpClientPool(this.properties.getPool());
    }

    @Bean
    public HttpPool restTemplatePool() {
        return new RestTemplatePool(this.properties.getPool());
    }

    @Bean
    public HttpPool okHttpPool() {
        return new OkHttpPool(this.properties.getPool());
    }
}

