package com.bxm.warcar.integration.autoconfigure.http;

import com.bxm.warcar.utils.http.HttpPool;
import com.bxm.warcar.utils.http.pool.HttpClientPool;
import com.bxm.warcar.utils.http.pool.OkHttpPool;
import com.bxm.warcar.utils.http.pool.RestTemplatePool;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

/**
 * <h3>http 连接池请求，默认使用{@link com.bxm.warcar.utils.http.pool.HttpClientPool}</h3>
 *  <p>
 *      其他实现{@link com.bxm.warcar.utils.http.pool.RestTemplatePool}
 *      {@link com.bxm.warcar.utils.http.pool.OkHttpPool}
 *  </p>
 * @author hcmony
 * @since V1.0.0, 2020/3/18 16:13
 */
@EnableConfigurationProperties(HttpPoolProperties.class)
public class HttpPoolAutoConfiguration {

    private final HttpPoolProperties properties;

    public HttpPoolAutoConfiguration(HttpPoolProperties properties) {
        this.properties = properties;
    }

    @Primary
    @Bean
    public HttpPool httpClientPool(){
        return new HttpClientPool(properties.getPool());
    }

    @Bean
    public HttpPool restTemplatePool(){
        return new RestTemplatePool(properties.getPool());
    }

    @Bean
    public HttpPool okHttpPool(){
        return new OkHttpPool(properties.getPool());
    }
}
